<?php get_header();
$term = get_queried_object();
$image = get_field('taxonomy_image', $term);
$description = get_field('taxonomy_description', $term);
$trip_expert = get_field('trip_expert_detail', 'option');
$social_media = get_field('social_media', 'option');
?>


<div class="pkg-category sp-tb">
    <div class="maincontainer">
        <div class="row">
            <div class="col-md-8">
                <div class="cate-intro">
                    <h2 class="cate-title"> <i class="fa-solid fa-map-location-dot"></i> <?php echo $term->name ?></h2>
                    <div class="pkg-count">Showing
                        <span>
                            <?php if (!empty($term->count)) {
                                echo $term->count;
                            } else {
                                echo 'No';
                            } ?>
                        </span> Results
                    </div>
                    <?php if (!empty($image)) { ?>
                        <img src="<?php echo $image['url']; ?>" alt="category image" title="category image">
                    <?php } else { ?>
                        <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/slider1.jpg" alt="category image" title="category image">
                    <?php } ?>
                    <div class="desc mt">
                        <?php echo $description; ?>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <?php if (!empty($trip_expert)) { ?>
                    <div class="expert cate-expert">
                        <h3>Talk To Trip Expert</h3>
                        <div class="exp-inner">
                            <div class="expert-intro d-flex">
                                <div class="image">
                                    <img src="<?php echo $trip_expert['image']['url']; ?>" alt="expert image" title="expert image">
                                </div>
                                <div class="name">
                                    <h4><?php echo $trip_expert['name']; ?></h4>
                                    <h5>Trip Expert</h5>
                                    <h6>Have Any Questions?</h6>
                                </div>
                            </div>
                            <p>
                                <?php echo $trip_expert['short_intro']; ?>
                            </p>
                            <div class="exp-contact">
                                <i class="fa-brands fa-whatsapp"></i>
                                <span>Whatsapp/Viber</span>
                                <a href="tel:<?php echo $trip_expert['phone']; ?>">+977-<?php echo $trip_expert['phone']; ?></a>
                            </div>
                            <div class="exp-media">
                                <h6>Get in Touch</h6>
                                <ul>
                                    <?php
                                    if (!empty($social_media)) {
                                        foreach ($social_media as $media) {
                                    ?>
                                            <li>
                                                <a href="<?php echo $media['link']; ?>" target="_blank"><?php echo $media['icon']; ?></a>
                                            </li>
                                    <?php }
                                    } ?>
                                </ul>
                            </div>
                        </div>
                        <a href="#" class="q-enquiry" data-bs-toggle="modal" data-bs-target="#enquiryModal">Quick Enquiry <i class="fa-solid fa-message"></i></a>
                    </div>
                <?php } ?>
            </div>
        </div>
        <div class="row">
            <?php
            $args = array(
                'post_type' => 'package',
                'tax_query' => array(
                    array(
                        'taxonomy' => $term->taxonomy,
                        'field' => 'slug',
                        'terms' => $term->slug,
                    ),
                ),
            );
            $query1 = new WP_Query($args);
            if (have_posts()) {
                while ($query1->have_posts()) {
                    $query1->the_post();
                    $destination = get_field('destination');
                    $duration = get_field('duration');
                    $price = get_field('price');
                    $group = get_field('group_size');
            ?>
                    <div class="col-lg-4 col-sm-6 d-flex mt">
                        <div class="card1">
                            <a href="<?php the_permalink(); ?>">
                                <div class="image">
                                    <img src="<?php the_post_thumbnail_url(); ?>" alt="package image" title="package image">
                                    <div class="price">
                                        <span>
                                            <?php if (!empty($price)) {
                                                echo $price;
                                            } else {
                                                echo 'Price On Request';
                                            } ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="text">
                                    <div class="duration"><i class="fa-regular fa-calendar-days"></i>
                                        <span>
                                            <?php if (!empty($duration)) {
                                                echo $duration;
                                            } else {
                                                echo 'Duration N/A';
                                            } ?>
                                        </span>
                                    </div>
                                    <h3 class="pkg-title"><?php the_title(); ?></h3>
                                    <div class="link"><i class="fa-solid fa-arrow-right"></i></div>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php }  ?>
                <?php
                // pagination
                $current_index = $wp_query->max_num_pages;
                if ($current_index > 1) {
                ?>
                    <div class="pagination mt">
                        <div class="pagenavi">
                            <?php
                            $current_index = $wp_query->max_num_pages;
                            $current_page = max(1, get_query_var('paged'));
                            echo paginate_links(array(
                                'format' => '?paged=%#%',
                                'show_all' => false,
                                'total' => $current_index,
                                'current' => $current_page,
                                'type' => 'plain',
                                'prev_next' => true,
                                'prev_text' => sprintf('<<'),
                                'next_text' => sprintf('>>'),
                            ));
                            ?>
                        </div>
                        <form>
                            <?php
                            if (!empty($_GET['cat'])) {
                            ?>
                                <input type="hidden" name="cat" value="<?php echo $_GET['cat']; ?>">
                            <?php } ?>
                            <input id="inputType" type="number" min="1" max="<?php echo $current_index ?>" name="paged" value="">
                            <button type="submit" id="submit">Go to page <i class="icon-chevron-right"></i></button>
                        </form>
                    </div>
            <?php }
            } ?>
        </div>
    </div>
</div>

<!-- Modal for quick enquiry starts -->
<div class="modal fade" id="enquiryModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Quick Enquiry</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php echo do_shortcode('[contact-form-7 id="0e7f4d9" title="Enquiry Form"]'); ?>
            </div>
        </div>
    </div>
</div>
<!-- Modal for quick enquiry ends -->
<?php get_footer(); ?>