<?php get_header();
$price = get_field('price');
$group_discount_price = get_field('group_discount_price');
$destination = get_field('destination');
$duration = get_field('duration');
$group_size = get_field('group_size');
$max_elevation = get_field('max_elevation');
$trek_difficulty = get_field('trek_difficulty');
$activities = get_field('activities');
$best_months = get_field('best_months');
$trip_startsends = get_field('trip_startsends');
$accomodation = get_field('accomodation');
$meals = get_field('meals');
$overview = get_field('overview');
$highlights = get_field('highlights');
$itinerary = get_field('itinerary');
$itinerary_conclusion = get_field('itinerary_conclusion');
$fixed_departure = get_field('fixed_departure');
$include = get_field('include');
$exclude = get_field('exclude');
$package_gallery = get_field('package_gallery');
$equipment = get_field('equipment');
$essential_info = get_field('essential_info');
$package_faq = get_field('package_faq');
$phone_number = get_field('phone_number', 'option');
$email_address = get_field('email_address', 'option');
$trip_expert = get_field('trip_expert_detail', 'option');
?>
<!-- package tab starts -->
<nav class="pkg-tab navbar">
    <div class="maincontainer">
        <ul class="navbar-nav">
            <?php if (!empty($overview)) { ?>
                <li class="nav-item">
                    <a class="nav-link" href="#overview">Overview</a>
                </li>
            <?php } ?>
            <?php if (!empty($itinerary)) { ?>
                <li class="nav-item">
                    <a class="nav-link" href="#itinerary">Itinerary</a>
                </li>
            <?php } ?>
            <?php if (!empty($fixed_departure)) { ?>
                <li class="nav-item">
                    <a class="nav-link" href="#fixeddeparture">Fixed Departure</a>
                </li>
            <?php } ?>
            <?php if (!empty($include || $exclude)) { ?>
                <li class="nav-item">
                    <a class="nav-link" href="#inc-exc">Includes & Excludes</a>
                </li>
            <?php } ?>

            <?php if (!empty($essential_info)) { ?>
                <li class="nav-item">
                    <a class="nav-link" href="#essential-info">Essential Info</a>
                </li>
            <?php } ?>
            <?php if (!empty($equipment)) { ?>
                <li class="nav-item">
                    <a class="nav-link" href="#equipment-list">Equipment List</a>
                </li>
            <?php } ?>
            <?php if (!empty($package_faq)) { ?>
                <li class="nav-item">
                    <a class="nav-link" href="#faq">FAQ</a>
                </li>
            <?php } ?>
        </ul>
    </div>
</nav>
<!-- package tab ends -->
<div class="single-package sp-tb">
    <div class="maincontainer">
        <div class="pkg-intro">
            <?php if (have_posts()) { ?>
                <h2 class="pkg-title"><?php the_title(); ?></h2>
                <div class="pkg-duration">
                    <i class="fa-solid fa-calendar-days"></i>
                    <span>
                        <?php if (!empty($duration)) {
                            echo $duration;
                        } else {
                            echo 'Duration N/A';
                        } ?>
                    </span>
                </div>
            <?php } ?>
        </div>
        <div class="row">
            <div class="col-lg-8 pkg-detail">
                <!-- package gallery starts -->
                <div class="swiper pkgGallery">
                    <div class="swiper-wrapper">
                        <?php
                        if (!empty($package_gallery)) {
                            foreach ($package_gallery as $pg) {
                        ?>
                                <div class="swiper-slide">
                                    <div class="image">
                                        <img src="<?php echo $pg['url']; ?>" alt="slide image" title="slide image">
                                    </div>
                                </div>
                            <?php }
                        } else { ?>
                            <div class="swiper-slide">
                                <div class="image">
                                    <img src="<?php the_post_thumbnail_url(); ?>" alt="package image" title="package image">
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
                <!-- package gallery ends -->

                <!-- trip facts starts -->
                <div class="trip-facts mt">
                    <ul>
                        <?php if (!empty($duration)) { ?>
                            <li>
                                <div class="tf-item">
                                    <i class="fa-solid fa-calendar-days"></i>
                                    <h3>Trip Duration</h3>
                                    <h4><?php echo $duration; ?></h4>
                                </div>
                            </li>
                        <?php } ?>

                        <?php if (!empty($group_size)) { ?>
                            <li>
                                <div class="tf-item">
                                    <i class="fa-solid fa-people-group"></i>
                                    <h3>Group Size</h3>
                                    <h4><?php echo $group_size; ?></h4>
                                </div>
                            </li>
                        <?php } ?>

                        <?php if (!empty($max_elevation)) { ?>
                            <li>
                                <div class="tf-item">
                                    <i class="fa-solid fa-mountain-sun"></i>
                                    <h3>Maximum Altitude</h3>
                                    <h4><?php echo $max_elevation; ?></h4>
                                </div>
                            </li>
                        <?php } ?>

                        <?php if (!empty($trek_difficulty)) { ?>
                            <li>
                                <div class="tf-item">
                                    <i class="fa-solid fa-gauge-high"></i>
                                    <h3>Trip Difficulty</h3>
                                    <h4><?php echo $trek_difficulty; ?></h4>
                                </div>
                            </li>
                        <?php } ?>

                        <?php if (!empty($activities)) { ?>
                            <li>
                                <div class="tf-item">
                                    <i class="fa-solid fa-person-hiking"></i>
                                    <h3>Activities</h3>
                                    <h4><?php echo $activities; ?></h4>
                                </div>
                            </li>
                        <?php } ?>

                        <?php if (!empty($best_months)) { ?>
                            <li>
                                <div class="tf-item">
                                    <i class="fa-solid fa-cloud-sun"></i>
                                    <h3>Best Season</h3>
                                    <h4><?php echo $best_months; ?></h4>
                                </div>
                            </li>
                        <?php } ?>

                        <?php if (!empty($trip_startsends)) { ?>
                            <li>
                                <div class="tf-item">
                                    <i class="fa-solid fa-route"></i>
                                    <h3>Trip Start & End</h3>
                                    <h4><?php echo $trip_startsends; ?></h4>
                                </div>
                            </li>
                        <?php } ?>

                        <?php if (!empty($meals)) { ?>
                            <li>
                                <div class="tf-item">
                                    <i class="fa-solid fa-bowl-food"></i>
                                    <h3>Meals</h3>
                                    <h4><?php echo $meals; ?></h4>
                                </div>
                            </li>
                        <?php } ?>

                        <?php if (!empty($accomodation)) { ?>
                            <li>
                                <div class="tf-item">
                                    <i class="fa-solid fa-bed-pulse"></i>
                                    <h3>Accomodation</h3>
                                    <h4><?php echo $accomodation; ?></h4>
                                </div>
                            </li>
                        <?php } ?>
                    </ul>
                </div>
                <!-- trip facts ends -->

                <!-- trip highlights starts -->
                <?php if (!empty($highlights)) { ?>
                    <div class="pkg-highlight mt">
                        <h3 class="p-title mt-0">Highlights</h3>
                        <?php echo $highlights; ?>
                    </div>
                <?php } ?>
                <!-- trip highlights ends -->

                <!-- trip overview starts -->
                <?php if (!empty($overview)) { ?>
                    <div class="pkg-info" id="overview">
                        <h3 class="p-title">Overview</h3>
                        <?php echo $overview; ?>
                    </div>
                <?php } ?>
                <!-- trip overview ends -->

                <!-- trip itinerary starts -->
                <?php if (!empty($itinerary)) { ?>
                    <div class="pkg-info" id="itinerary">
                        <h3 class="p-title">Itinerary</h3>
                        <div class="accordion" id="accordionExample">
                            <!-- itinerary item -->
                            <?php
                            $count = 1;
                            foreach ($itinerary as $iti) {
                            ?>
                                <div class="accordion-item">
                                    <h4 class="iti-day">Day <span><?php echo sprintf("%02d", $count); ?></span></h4>
                                    <div class="iti-det">
                                        <div class="accordion-header">
                                            <?php $count++; ?>
                                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#iti<?php echo $count; ?>" aria-expanded="true" aria-controls="collapseOne">
                                                <?php echo $iti['itinerary_title']; ?>
                                            </button>
                                        </div>
                                        <div id="iti<?php echo $count; ?>" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                                            <div class="accordion-body">
                                                <?php echo $iti['itinerary_description']; ?>
                                                <div class="iti-facts">
                                                    <?php if (!empty($iti['duration'])) { ?>
                                                        <div class="fact-item">
                                                            <i class="fa-solid fa-clock-rotate-left"></i>
                                                            <h5>Duration</h5>
                                                            <span><?php echo $iti['duration']; ?></span>
                                                        </div>
                                                    <?php } ?>

                                                    <?php if (!empty($iti['altitude'])) { ?>
                                                        <div class="fact-item">
                                                            <i class="fa-solid fa-mountain"></i>
                                                            <h5>Altitude</h5>
                                                            <span><?php echo $iti['altitude']; ?></span>
                                                        </div>
                                                    <?php } ?>

                                                    <?php if (!empty($iti['meal'])) { ?>
                                                        <div class="fact-item">
                                                            <i class="fa-solid fa-utensils"></i>
                                                            <h5>Meal</h5>
                                                            <span><?php echo $iti['meal']; ?></span>
                                                        </div>
                                                    <?php } ?>

                                                    <?php if (!empty($iti['accomodation'])) { ?>
                                                        <div class="fact-item">
                                                            <i class="fa-solid fa-bed"></i>
                                                            <h5>Accomodation</h5>
                                                            <span><?php echo $iti['accomodation']; ?></span>
                                                        </div>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                        <div class="itinerary-conclusion mt">
                            <?php echo $itinerary_conclusion; ?>
                        </div>
                    </div>
                <?php } ?>
                <!-- trip itinerary ends -->

                <!-- trip fixed departure starts -->
                <?php if (!empty($fixed_departure)) { ?>
                    <div class="pkg-info" id="fixeddeparture">
                        <h3 class="p-title">Fixed Departure</h3>
                        <table class="table table-bordered mb-0">
                            <thead>
                                <th>Start Date</th>
                                <th>End Date</th>
                                <th>Price</th>
                                <th>Space Left</th>
                            </thead>
                            <tbody>
                                <?php foreach ($fixed_departure as $fd) { ?>
                                    <tr>
                                        <td><?php echo $fd['start_date']; ?></td>
                                        <td><?php echo $fd['end_date']; ?></td>
                                        <td><?php echo $fd['fdprice']; ?></td>
                                        <td><?php echo $fd['space_left']; ?></td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                <?php } ?>
                <!-- trip fixed departure ends -->

                <!-- trip include/exclude starts -->
                <?php if (!empty($include) || !empty($exclude)) { ?>
                    <div class="pkg-info" id="inc-exc">
                        <div class="pkg-include">
                            <h3 class="p-title">What's Included</h3>
                            <?php echo $include; ?>
                        </div>
                        <div class="pkg-exclude">
                            <h3 class="p-title">What's Excluded</h3>
                            <?php echo $exclude; ?>
                        </div>
                    </div>
                <?php } ?>
                <!-- trip include/exclude ends -->

                <!-- essential info starts -->
                <?php if (!empty($essential_info)) { ?>
                    <div class="pkg-info" id="essential-info">
                        <h3 class="p-title">Essential Info</h3>
                        <?php echo $essential_info; ?>
                    </div>
                <?php } ?>
                <!-- essential info ends -->

                <!-- equipment list starts -->
                <?php if (!empty($equipment)) { ?>
                    <div class="pkg-info" id="equipment-list">
                        <h3 class="p-title">Equipment List</h3>
                        <?php echo $equipment; ?>
                    </div>
                <?php } ?>
                <!-- equipment list ends -->

                <!-- trip faq starts -->
                <?php if (!empty($package_faq)) { ?>
                    <div class="pkg-info" id="faq">
                        <h3 class="p-title">FAQ</h3>
                        <div class="accordion" id="accordionFAQ">
                            <?php
                            $count = 0;
                            foreach ($package_faq as $faq) {
                            ?>
                                <!-- faq item -->
                                <div class="accordion-item">
                                    <div class="accordion-header">
                                        <?php $count++; ?>
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq<?php echo $count; ?>" aria-expanded="true" aria-controls="faq<?php echo $count; ?>">
                                            <?php echo $faq['faq_title']; ?>
                                        </button>
                                    </div>
                                    <div id="faq<?php echo $count; ?>" class="accordion-collapse collapse" data-bs-parent="#accordionFAQ">
                                        <div class="accordion-body">
                                            <?php echo $faq['faq_description']; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                    <!-- trip faq ends -->
                <?php } ?>
            </div>
            <div class="col-lg-4">
                <div class="price-wrap">
                    <div class="price-info">
                        <h5>Trip Price</h5>
                        <h2>
                            <?php if (!empty($price)) {
                                echo $price;
                            } else {
                                echo 'On Request';
                            } ?>
                            <?php if (!empty($price)) { ?><span>Per Person</span><?php } ?>
                        </h2>
                    </div>
                    <?php if (!empty($group_discount_price)) { ?>
                        <div class="dropdown group-discount">
                            <button class="dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                Group Discount Price
                            </button>
                            <ul class="dropdown-menu">
                                <?php foreach ($group_discount_price as $gdp) { ?>
                                    <li>
                                        <span><?php echo $gdp['group_size']; ?></span>
                                        <h5><?php echo $gdp['discounted_price']; ?></h5>
                                    </li>
                                <?php } ?>
                            </ul>
                        </div>
                    <?php } ?>
                    <div class="be-btn">
                        <a href="#" class="btn-one" data-bs-toggle="modal" data-bs-target="#bookModal">Book Now</a>
                        <a href="#" class="btn-one" data-bs-toggle="modal" data-bs-target="#enquiryModal">Quick Enquiry</a>
                    </div>
                </div>
                <?php if (!empty($trip_expert)) { ?>
                    <div class="expert single-expert mt">
                        <h3>Talk To Trip Expert</h3>
                        <div class="exp-inner">
                            <div class="expert-intro d-flex">
                                <div class="image">
                                    <img src="<?php echo $trip_expert['image']['url']; ?>" alt="expert image" title="expert image">
                                </div>
                                <div class="name">
                                    <h4><?php echo $trip_expert['name']; ?></h4>
                                    <h5>Trip Expert</h5>
                                    <h6>Have Any Questions?</h6>
                                </div>
                            </div>
                            <p>
                                <?php echo $trip_expert['short_intro']; ?>
                            </p>
                            <div class="exp-contact">
                                <i class="fa-brands fa-whatsapp"></i>
                                <span>Whatsapp/Viber</span>
                                <a href="tel:<?php echo $trip_expert['phone']; ?>">+977-<?php echo $trip_expert['phone']; ?></a>
                            </div>
                            <div class="exp-media">
                                <h6>Share this Trip</h6>
                                <ul>
                                    <li>
                                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" target="_blank">
                                            <i class="fa-brands fa-facebook-f"></i>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="https://twitter.com/intent/tweet?text=<?php the_permalink(); ?>" target="_blank">
                                            <i class="fa-brands fa-x-twitter"></i>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>" target="_blank">
                                            <i class="fa-brands fa-linkedin-in"></i>
                                        </a>
                                    </li>
                                    <li>
                                        <a href="#" target="_blank">
                                            <i class="fa-brands fa-instagram"></i>
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <a href="#" class="q-enquiry" data-bs-toggle="modal" data-bs-target="#enquiryModal">Quick Enquiry <i class="fa-solid fa-message"></i></a>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</div>

<!-- =====related packages starts===== -->
<section class="related-trip sp-b">
    <div class="maincontainer">
        <div class="section-heading text-center mb">
            <span>You May also Like</span>
            <h2>Related Trips</h2>
            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/divider.png" alt="divider" title="divider">
        </div>
        <div class="swiper packageSlider1">
            <div class="swiper-wrapper">
                <?php example_cats_related_post(); ?>
            </div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        </div>
    </div>
</section>
<!-- =====related packages ends===== -->

<!-- Modal for quick enquiry starts -->
<div class="modal fade" id="enquiryModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Quick Enquiry</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <?php echo do_shortcode('[contact-form-7 id="0e7f4d9" title="Enquiry Form"]'); ?>
                <!-- <form action="">
                    <label>Full Name <span>*</span></label>
                    <input type="text" class="form-control" placeholder="Enter your name">
                    <label>Email <span>*</span></label>
                    <input type="email" class="form-control" placeholder="Enter your email">
                    <label>Phone <span>*</span></label>
                    <input type="text" class="form-control" placeholder="Enter your phone">
                    <label>Subject</label>
                    <input type="text" class="form-control" placeholder="Enter subject">
                    <label>Message <span>*</span></label>
                    <textarea class="form-control" placeholder="Enter message"></textarea>
                    <input type="submit" value="Submit Now">
                </form> -->
            </div>
        </div>
    </div>
</div>
<!-- Modal for quick enquiry ends -->
<!-- Modal for quick enquiry starts -->
<div class="modal fade" id="bookModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Book This Trip</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="">
                    <label>Full Name <span>*</span></label>
                    <input type="text" class="form-control" placeholder="Enter your name">
                    <label>Email <span>*</span></label>
                    <input type="email" class="form-control" placeholder="Enter your email">
                    <label>Phone <span>*</span></label>
                    <input type="text" class="form-control" placeholder="Enter your phone">
                    <label>Subject</label>
                    <input type="text" class="form-control" placeholder="Enter subject">
                    <label>Message <span>*</span></label>
                    <textarea class="form-control" placeholder="Enter message"></textarea>
                    <input type="submit" value="Submit Now">
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Modal for quick enquiry ends -->
<?php get_footer(); ?>

