<?php get_header(); ?>
<!-- package tab starts -->
<nav class="pkg-tab navbar">
    <div class="maincontainer">
        <ul class="navbar-nav">
            <li class="nav-item">
                <a class="nav-link" href="#overview">Overview</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#itinerary">Itinerary</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#fixeddeparture">Fixed Departure</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#inc-exc">Includes & Excludes</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#essential-info">Essentional Info</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#equipment">Equipment List</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="#faq">FAQ</a>
            </li>
        </ul>
    </div>
</nav>
<!-- package tab ends -->
<div class="single-package sp-tb">
    <div class="maincontainer">
        <div class="pkg-intro">
            <h2 class="pkg-title">Everest Base Camp Trek</h2>
            <div class="pkg-duration">
                <i class="fa-solid fa-calendar-days"></i> <span>12 Days/ 11 Nights</span>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-8 pkg-detail">
                <div class="swiper pkgGallery">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <div class="image">
                                <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/mi4.jpg" alt="slide image" title="slide image">
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="image">
                                <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/slider22.jpg" alt="slide image" title="slide image">
                            </div>
                        </div>
                        <div class="swiper-slide">
                            <div class="image">
                                <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/mi3.jpg" alt="slide image" title="slide image">
                            </div>
                        </div>
                    </div>
                    <div class="swiper-button-next"></div>
                    <div class="swiper-button-prev"></div>
                </div>
                <div class="trip-facts mt">
                    <ul>
                        <li>
                            <div class="tf-item">
                                <i class="fa-solid fa-calendar-days"></i>
                                <h3>Trip Duration</h3>
                                <h4>12 Days/ 11 Nights</h4>
                            </div>
                        </li>
                        <li>
                            <div class="tf-item">
                                <i class="fa-solid fa-people-group"></i>
                                <h3>Group Size</h3>
                                <h4>10-12 People</h4>
                            </div>
                        </li>
                        <li>
                            <div class="tf-item">
                                <i class="fa-solid fa-mountain-sun"></i>
                                <h3>Maximum Altitude</h3>
                                <h4>5689 m</h4>
                            </div>
                        </li>
                        <li>
                            <div class="tf-item">
                                <i class="fa-solid fa-gauge-high"></i>
                                <h3>Trip Difficulty</h3>
                                <h4>Moderate</h4>
                            </div>
                        </li>
                        <li>
                            <div class="tf-item">
                                <i class="fa-solid fa-person-hiking"></i>
                                <h3>Activities</h3>
                                <h4>Trekking, Hiking</h4>
                            </div>
                        </li>
                        <li>
                            <div class="tf-item">
                                <i class="fa-solid fa-cloud-sun"></i>
                                <h3>Best Season</h3>
                                <h4>September-November</h4>
                            </div>
                        </li>
                        <li>
                            <div class="tf-item">
                                <i class="fa-solid fa-route"></i>
                                <h3>Trip Start & End</h3>
                                <h4>Kathmandu-Kathmandu</h4>
                            </div>
                        </li>
                        <li>
                            <div class="tf-item">
                                <i class="fa-solid fa-bowl-food"></i>
                                <h3>Meals</h3>
                                <h4>Lunch, Dinner, Breakfast</h4>
                            </div>
                        </li>
                        <li>
                            <div class="tf-item">
                                <i class="fa-solid fa-bed-pulse"></i>
                                <h3>Accomodation</h3>
                                <h4>Tea-House</h4>
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="pkg-highlight mt">
                    <h3 class="p-title mt-0">Highlights</h3>
                    <ul>
                        <li>Stunning close-up views of Mt. Everest, Lhotse, Nuptse, Ama Dablam, and other Himalayan giants</li>
                        <li>Sunrise from Kala Patthar, offering the best panoramic view of Everest</li>
                        <li>Stand at the iconic Everest Base Camp, surrounded by glaciers and icefalls</li>
                        <li>Experience warm Sherpa hospitality and explore cultural villages like Namche Bazaar and Tengboche</li>
                        <li>Visit the famous Tengboche Monastery with its serene spiritual atmosphere</li>
                        <li>Trek through diverse landscapes — rhododendron forests, alpine meadows, and glacial valleys</li>
                        <li>Cross thrilling suspension bridges over the Dudh Koshi River</li>
                        <li>Explore lively Namche Bazaar, the gateway to the Everest region</li>
                        <li>Walk in the footsteps of legendary mountaineers Hillary and Tenzing Norgay</li>
                        <li>A once-in-a-lifetime adventure to the base of the world’s highest mountain</li>
                    </ul>
                </div>
                <div class="pkg-info" id="overview">
                    <h3 class="p-title">Overview</h3>
                    <p>
                        The Everest Base Camp Trek is one of the most iconic and awe-inspiring adventures in the world, taking trekkers deep into the heart of the Himalayas. Starting from the vibrant mountain town of Lukla, the journey winds through picturesque Sherpa villages, ancient monasteries, and lush forests of rhododendron and pine. As the trail ascends, trekkers are greeted by breathtaking views of towering peaks such as Ama Dablam, Lhotse, Nuptse, and the mighty Mount Everest itself, creating an unforgettable Himalayan panorama at every turn.
                    </p>
                    <p>
                        This trek is not just about reaching the base camp; it’s also a cultural immersion into the Sherpa way of life. Along the way, travelers pass through charming villages like Namche Bazaar, the bustling gateway to Everest, and Tengboche, home to one of the region’s most famous monasteries. The warmth and hospitality of the Sherpa people, coupled with their deep-rooted Buddhist traditions, offer a profound cultural experience that complements the natural beauty of the region.
                    </p>
                    <p>
                        Reaching Everest Base Camp (5,364 meters) is a moment of triumph and inspiration, as trekkers stand face-to-face with the world’s highest mountain. The journey is both physically challenging and deeply rewarding, demanding endurance, acclimatization, and determination. Whether it’s watching the sunrise over Kala Patthar, gazing upon the Khumbu Icefall, or simply breathing the crisp Himalayan air, every step of the Everest Base Camp Trek is a testament to adventure, spirit, and the allure of the world’s greatest mountains.
                    </p>
                </div>
                <div class="pkg-info" id="itinerary">
                    <h3 class="p-title">Itinerary</h3>
                    <div class="accordion" id="accordionExample">
                        <!-- itinerary item -->
                        <div class="accordion-item">
                            <h4 class="iti-day">Day <span>01</span></h4>
                            <div class="iti-det">
                                <div class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#iti1" aria-expanded="true" aria-controls="collapseOne">
                                        Arrive at the Kathmandu International Airport and transfer to hotel
                                    </button>
                                </div>
                                <div id="iti1" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>
                                            Begin with a scenic flight from Kathmandu to Lukla, offering your first glimpse of the mighty Himalayas. The trek starts with a gentle descent through pine forests and Sherpa villages before reaching Phakding along the Dudh Koshi River.
                                        </p>
                                        <div class="iti-facts">
                                            <div class="fact-item">
                                                <i class="fa-solid fa-clock-rotate-left"></i>
                                                <h5>Duration</h5>
                                                <span>30 min</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-mountain"></i>
                                                <h5>Altitude</h5>
                                                <span>2350 m</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-utensils"></i>
                                                <h5>Meal</h5>
                                                <span>Breakfast</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-bed"></i>
                                                <h5>Accomodation</h5>
                                                <span>Hotel</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- itinerary item -->
                        <div class="accordion-item">
                            <h4 class="iti-day">Day <span>02</span></h4>
                            <div class="iti-det">
                                <div class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#iti1" aria-expanded="true" aria-controls="collapseOne">
                                        Kathmandu Sightseeing & Trek Preparation
                                    </button>
                                </div>
                                <div id="iti1" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>
                                            Explore the rich cultural heritage of Kathmandu. Visit Pashupatinath Temple, a UNESCO World Heritage Site, and Boudhanath Stupa, one of the largest stupas in the world. Stroll through the historic streets of Kathmandu Durbar Square, observing traditional architecture and local life. Prepare your trekking gear and make final arrangements for the upcoming flight to Lukla.
                                        </p>
                                        <div class="iti-facts">
                                            <div class="fact-item">
                                                <i class="fa-solid fa-clock-rotate-left"></i>
                                                <h5>Duration</h5>
                                                <span>4 hrs</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-mountain"></i>
                                                <h5>Altitude</h5>
                                                <span>2150 m</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-utensils"></i>
                                                <h5>Meal</h5>
                                                <span>Breakfast, Lunch</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-bed"></i>
                                                <h5>Accomodation</h5>
                                                <span>Hotel</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- itinerary item -->
                        <div class="accordion-item">
                            <h4 class="iti-day">Day <span>03</span></h4>
                            <div class="iti-det">
                                <div class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#iti1" aria-expanded="true" aria-controls="collapseOne">
                                        Fly to Lukla – Trek to Phakding (2,610 m / 8,563 ft) </button>
                                </div>
                                <div id="iti1" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>
                                            Take a thrilling early morning flight to Lukla, surrounded by the breathtaking Himalayan peaks. Begin the trek along the Dudh Koshi River, passing through pine forests and small villages. The trail offers your first taste of Sherpa culture and the stunning mountain scenery. Arrive in Phakding, a quiet village nestled in the valley, and spend the night in a teahouse.
                                        </p>
                                        <div class="iti-facts">
                                            <div class="fact-item">
                                                <i class="fa-solid fa-clock-rotate-left"></i>
                                                <h5>Duration</h5>
                                                <span>3 hrs</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-mountain"></i>
                                                <h5>Altitude</h5>
                                                <span>2610 m</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-utensils"></i>
                                                <h5>Meal</h5>
                                                <span>Breakfast, Lunch</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-bed"></i>
                                                <h5>Accomodation</h5>
                                                <span>Hotel</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- itinerary item -->
                        <div class="accordion-item">
                            <h4 class="iti-day">Day <span>04</span></h4>
                            <div class="iti-det">
                                <div class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#iti1" aria-expanded="true" aria-controls="collapseOne">
                                        Phakding to Namche Bazaar (3,440 m / 11,286 ft)
                                    </button>
                                </div>
                                <div id="iti1" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>
                                            The trek today gradually ascends through beautiful forests, crossing several suspension bridges over the Dudh Koshi River. Pass through Sherpa villages and enjoy glimpses of local life. Reach Namche Bazaar, the gateway to the high Himalayas, bustling with markets, lodges, and teahouses. Take in your first spectacular views of Mount Everest from a distance.
                                        </p>
                                        <p>
                                            Begin with a scenic flight from Kathmandu to Lukla, offering your first glimpse of the mighty Himalayas. The trek starts with a gentle descent through pine forests and Sherpa villages before reaching Phakding along the Dudh Koshi River.
                                        </p>
                                        <div class="iti-facts">
                                            <div class="fact-item">
                                                <i class="fa-solid fa-clock-rotate-left"></i>
                                                <h5>Duration</h5>
                                                <span>5 hrs</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-mountain"></i>
                                                <h5>Altitude</h5>
                                                <span>3440 m</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-utensils"></i>
                                                <h5>Meal</h5>
                                                <span>Breakfast</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-bed"></i>
                                                <h5>Accomodation</h5>
                                                <span>Hotel</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- itinerary item -->
                        <div class="accordion-item">
                            <h4 class="iti-day">Day <span>05</span></h4>
                            <div class="iti-det">
                                <div class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#iti1" aria-expanded="true" aria-controls="collapseOne">
                                        Acclimatization in Namche Bazaar
                                    </button>
                                </div>
                                <div id="iti1" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>
                                            With a scenic flight from Kathmandu to Lukla, offering your first glimpse of the mighty Himalayas. The trek starts with a gentle descent through pine forests and Sherpa villages before reaching Phakding along the Dudh Koshi River.
                                        </p>
                                        <p>
                                            Spend the day acclimatizing to the altitude in Namche Bazaar. Take a short hike to the Everest View Hotel or nearby hills for panoramic views of Everest, Lhotse, and Ama Dablam. Explore the local market, interact with the Sherpa people, and enjoy traditional tea and snacks. This day helps your body adjust to higher altitudes before continuing to higher elevations.
                                        </p>
                                        <div class="iti-facts">
                                            <div class="fact-item">
                                                <i class="fa-solid fa-clock-rotate-left"></i>
                                                <h5>Duration</h5>
                                                <span>4 hrs</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-mountain"></i>
                                                <h5>Altitude</h5>
                                                <span>2550 m</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-utensils"></i>
                                                <h5>Meal</h5>
                                                <span>Breakfast, Lunch, Dinner</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-bed"></i>
                                                <h5>Accomodation</h5>
                                                <span>Hotel</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- itinerary item -->
                        <div class="accordion-item">
                            <h4 class="iti-day">Day <span>06</span></h4>
                            <div class="iti-det">
                                <div class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#iti1" aria-expanded="true" aria-controls="collapseOne">
                                        Namche Bazaar to Tengboche (3,860 m / 12,664 ft)
                                    </button>
                                </div>
                                <div id="iti1" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>
                                            Trek Begin with a scenic flight from Kathmandu to Lukla, offering your first glimpse of the mighty Himalayas. The trek starts with a gentle descent through pine forests and Sherpa villages before reaching Phakding along the Dudh Koshi River.
                                        </p>
                                        <p>
                                            Trek through lush rhododendron and pine forests, passing several small villages along the way. Arrive at Tengboche, home to the famous Tengboche Monastery. This is one of the most spiritual sites in the Khumbu region, with stunning views of Ama Dablam and other towering peaks. Spend the evening observing monastic rituals and the peaceful surroundings.
                                        </p>
                                        <div class="iti-facts">
                                            <div class="fact-item">
                                                <i class="fa-solid fa-clock-rotate-left"></i>
                                                <h5>Duration</h5>
                                                <span>5 hrs</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-mountain"></i>
                                                <h5>Altitude</h5>
                                                <span>2860 m</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-utensils"></i>
                                                <h5>Meal</h5>
                                                <span>Breakfast, Lunch, Dinner</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-bed"></i>
                                                <h5>Accomodation</h5>
                                                <span>Hotel</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- itinerary item -->
                        <div class="accordion-item">
                            <h4 class="iti-day">Day <span>07</span></h4>
                            <div class="iti-det">
                                <div class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#iti1" aria-expanded="true" aria-controls="collapseOne">
                                        Tengboche to Dingboche (4,360 m / 14,305 ft)
                                    </button>
                                </div>
                                <div id="iti1" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <p>
                                            Begin with a scenic flight from Kathmandu to Lukla, offering your first glimpse of the mighty Himalayas. The trek starts with a gentle descent through pine forests and Sherpa villages before reaching Phakding along the Dudh Koshi River.
                                        </p>
                                        <div class="iti-facts">
                                            <div class="fact-item">
                                                <i class="fa-solid fa-clock-rotate-left"></i>
                                                <h5>Duration</h5>
                                                <span>7 hrs</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-mountain"></i>
                                                <h5>Altitude</h5>
                                                <span>4360 m</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-utensils"></i>
                                                <h5>Meal</h5>
                                                <span>Breakfast, Lunch, Dinner</span>
                                            </div>
                                            <div class="fact-item">
                                                <i class="fa-solid fa-bed"></i>
                                                <h5>Accomodation</h5>
                                                <span>Hotel</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="pkg-info" id="inc-exc">
                    <h3 class="p-title">What's Included</h3>
                    <div class="pkg-include">
                        <ul>
                            <li>Airport transfers in Kathmandu (arrival & departure)</li>
                            <li>Domestic flight from Kathmandu to Lukla and return</li>
                            <li>All teahouse/lodge accommodation during the trek</li>
                            <li>Three meals per day (breakfast, lunch, and dinner) during the trek</li>
                            <li>Professional English-speaking trekking guide</li>
                            <li>Experienced Sherpa porter for luggage (1 porter per 2 trekkers)</li>
                            <li>Trekking permits: Sagarmatha National Park Entry Permit & TIMS card</li>
                            <li>Comprehensive first aid kit and oxygen cylinder for emergencies</li>
                            <li>Pre-trek briefing in Kathmandu</li>
                            <li>Emergency evacuation support</li>
                        </ul>
                    </div>
                    <div class="pkg-exclude">
                        <h3 class="p-title">What's Excluded</h3>
                        <ul>
                            <li>International airfare to/from Kathmandu</li>
                            <li>Travel and rescue insurance (including helicopter evacuation)</li>
                            <li>Visa fees for Nepal</li>
                            <li>Personal trekking gear and clothing</li>
                            <li>Meals in Kathmandu and Lukla (outside the trek)</li>
                            <li>Hot showers, drinks, snacks, and personal expenses during trek</li>
                            <li>Tips for guides and porters</li>
                            <li>Optional excursions or activities outside the itinerary</li>
                        </ul>
                    </div>
                </div>
                <div class="pkg-info" id="essential-info">
                    <h3 class="p-title">Essential Info</h3>
                    <h4>Best Time to Trek</h4>
                    <p>The Everest Base Camp trek is best experienced in two main seasons:</p>
                    <ul>
                        <li>
                            <strong>Spring (March–May):</strong> The trail comes alive with rhododendron forests and blooming alpine flora. Mornings are generally clear, offering spectacular mountain vistas, though occasional afternoon clouds can appear. Snow on higher passes usually starts melting, making trekking easier. Wildlife is active, and photography opportunities are excellent with vibrant contrasts.
                        </li>
                        <li>
                            <strong>Autumn (September–November):</strong> Post-monsoon clarity brings unmatched visibility and crisp, cool nights. Trails are livelier, lodges are well-stocked, and high-altitude paths are firm and stable. Late October to early November is ideal for deep-blue skies and unobstructed views of Everest, Lhotse, and Ama Dablam.
                        </li>
                        <li>
                            <strong>Shoulder Periods:</strong> Early December can still offer good trekking if weather permits, though it is colder and days are shorter. Late February marks the start of spring trekking, but snow may linger on high passes. Monsoon (June–August) brings lush green landscapes and quiet trails at lower elevations, but the high passes remain wet, slippery, and challenging.
                        </li>
                    </ul>
                    <h4>Duration and Difficulty</h4>
                    <p>
                        The classic Everest Base Camp trek takes 14–15 days from Kathmandu to Kathmandu, including acclimatization and rest days. It is rated moderate to strenuous, suitable for physically fit trekkers. Altitudes reach Kala Patthar at 5,545 m and EBC at 5,364 m, requiring proper acclimatization. The trail includes gradual ascents, rocky paths, and occasional icy sections, so preparation and stamina are key.
                    </p>
                    <h4>Accommodation and Meals</h4>
                    <p>
                        Accommodation along the trail is in teahouses and lodges, offering basic facilities and shared bathrooms. Meals typically include breakfast, lunch, and dinner, focusing on local Nepali cuisine such as dal bhat, noodles, and soups. Hot showers are limited and usually charged separately.
                    </p>
                </div>
                <div class="pkg-info" id="equipment">
                    <h3 class="p-title">Equipment List</h3>
                    <h4>Essential Equipment for Everest Base Camp Trek</h4>
                    <ul>
                        <li><strong>Trekking Clothing:</strong> Thermal base layers, moisture-wicking t-shirts, fleece jacket, insulated down jacket, trekking pants, waterproof jacket and pants.</li>
                        <li><strong>Footwear:</strong> Sturdy trekking boots (broken-in), warm socks, camp shoes or sandals for lodges.</li>
                        <li><strong>Accessories:</strong> Warm hat, gloves, sun hat, buff or scarf, sunglasses with UV protection.</li>
                        <li><strong>Backpack:</strong> 40–50L daypack for daily essentials; rain cover included.</li>
                        <li><strong>Sleeping Gear:</strong> Sleeping bag rated for -10°C to -15°C, liner for hygiene.</li>
                        <li><strong>Trekking Poles:</strong> Adjustable poles to reduce strain on knees and aid balance.</li>
                        <li><strong>Personal Items:</strong> Water bottles or hydration bladder (2–3L), water purification tablets or filter, personal toiletries, towel, wet wipes, hand sanitizer.</li>
                        <li><strong>Medical & Safety:</strong> First aid kit, personal medications, sunscreen (high SPF), lip balm, insect repellent, altitude sickness medication (consult doctor).</li>
                        <li><strong>Electronics:</strong> Camera, power bank, spare batteries, phone, charger, headlamp with extra batteries.</li>
                        <li><strong>Documents & Money:</strong> Passport, trekking permits (TIMS & Sagarmatha National Park), travel insurance, cash in Nepalese Rupees.</li>
                        <li><strong>Optional Items:</strong> Gaiters for snow, crampons (if trekking in late autumn/winter), trekking journal, snacks, trekking guidebooks.</li>
                    </ul>
                </div>
                <div class="pkg-info" id="faq">
                    <h3 class="p-title">FAQ</h3>
                    <div class="accordion" id="accordionFAQ">
                        <!-- faq item -->
                        <div class="accordion-item">
                            <div class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#fa1" aria-expanded="true" aria-controls="fa1">
                                    The weather forecast says rain/clouds/snow in Lukla on our Flight Day. Are we in for a rough flight?
                                </button>
                            </div>
                            <div id="fa1" class="accordion-collapse collapse" data-bs-parent="#accordionFAQ">
                                <div class="accordion-body">
                                    <p>
                                        When you are up in the mountains in Nepal, we would suggest you to be ready for anything. Weather forecasts for Lukla are never correct and different sources will give you different information. If it is a really bad day in terms of weather, the airlines will themselves cancel the flight and you might have to wait till the weather clears. Yes, flying in high altitude is never easy, even on a clear sunny day, the plane might face turbulence because of the wind blowing from the mountains.
                                        But overall the flight to Lukla is very exciting and it’s an experience that you will never forget.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- faq item -->
                        <div class="accordion-item">
                            <div class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2" aria-expanded="true" aria-controls="faq2">
                                    What temperatures can you expect at the EBC during spring and autumn?
                                </button>
                            </div>
                            <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#accordionFAQ">
                                <div class="accordion-body">
                                    <p>
                                        When you are up in the mountains in Nepal, we would suggest you to be ready for anything. Weather forecasts for Lukla are never correct and different sources will give you different information. If it is a really bad day in terms of weather, the airlines will themselves cancel the flight and you might have to wait till the weather clears. Yes, flying in high altitude is never easy, even on a clear sunny day, the plane might face turbulence because of the wind blowing from the mountains.
                                        But overall the flight to Lukla is very exciting and it’s an experience that you will never forget.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- faq item -->
                        <div class="accordion-item">
                            <div class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq3" aria-expanded="true" aria-controls="faq3">
                                    How much tips should I give to the guide, porter and driver?
                                </button>
                            </div>
                            <div id="faq3" class="accordion-collapse collapse" data-bs-parent="#accordionFAQ">
                                <div class="accordion-body">
                                    <p>
                                        When you are up in the mountains in Nepal, we would suggest you to be ready for anything. Weather forecasts for Lukla are never correct and different sources will give you different information. If it is a really bad day in terms of weather, the airlines will themselves cancel the flight and you might have to wait till the weather clears. Yes, flying in high altitude is never easy, even on a clear sunny day, the plane might face turbulence because of the wind blowing from the mountains.
                                        But overall the flight to Lukla is very exciting and it’s an experience that you will never forget.
                                    </p>
                                </div>
                            </div>
                        </div>
                        <!-- faq item -->
                        <div class="accordion-item">
                            <div class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq4" aria-expanded="true" aria-controls="faq4">
                                    Can I make payment with my credit card or with my own currency while Everest trekking?
                                </button>
                            </div>
                            <div id="faq4" class="accordion-collapse collapse" data-bs-parent="#accordionFAQ">
                                <div class="accordion-body">
                                    <p>
                                        When you are up in the mountains in Nepal, we would suggest you to be ready for anything. Weather forecasts for Lukla are never correct and different sources will give you different information. If it is a really bad day in terms of weather, the airlines will themselves cancel the flight and you might have to wait till the weather clears. Yes, flying in high altitude is never easy, even on a clear sunny day, the plane might face turbulence because of the wind blowing from the mountains.
                                        But overall the flight to Lukla is very exciting and it’s an experience that you will never forget.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="price-wrap">
                    <div class="price-info">
                        <h5>Trip Price</h5>
                        <h2>USD 1450 <span>Per Person</span></h2>
                    </div>
                    <div class="dropdown group-discount">
                        <button class="dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                            Dropdown button
                        </button>
                        <ul class="dropdown-menu">
                            <li><span>1 Person</span>
                                <h5>USD 1450</h5>
                            </li>
                            <li><span>2 Person</span>
                                <h5>USD 1400</h5>
                            </li>
                            <li><span>3-6 Person</span>
                                <h5>USD 1350</h5>
                            </li>
                            <li><span>7-12 Person</span>
                                <h5>USD 1250</h5>
                            </li>
                            <li><span>13-16 Person</span>
                                <h5>USD 1150</h5>
                            </li>
                        </ul>
                    </div>
                    <div class="be-btn">
                        <a href="#" class="btn-one" data-bs-toggle="modal" data-bs-target="#bookModal">Book Now</a>
                        <a href="#" class="btn-one" data-bs-toggle="modal" data-bs-target="#enquiryModal">Quick Enquiry</a>
                    </div>
                </div>
                <div class="expert single-expert mt">
                    <h3>Talk To Trip Expert</h3>
                    <div class="exp-inner">
                        <div class="expert-intro d-flex">
                            <div class="image">
                                <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/u1.jpg" alt="expert image" title="expert image">
                            </div>
                            <div class="name">
                                <h4>Daniel Rivera</h4>
                                <h5>Trip Expert</h5>
                                <h6>Have Any Questions?</h6>
                            </div>
                        </div>
                        <p>
                            A seasoned travel expert with years of experience crafting personalized journeys and unforgettable adventures.
                        </p>
                        <div class="exp-contact">
                            <i class="fa-brands fa-whatsapp"></i>
                            <span>Whatsapp/Viber</span>
                            <a href="tel:">+977-1234567890</a>
                        </div>
                        <div class="exp-media">
                            <h6>Get In Touch</h6>
                            <ul>
                                <li><a href="#" target="_blank"><i class="fa-brands fa-facebook-f"></i></a></li>
                                <li><a href="#" target="_blank"><i class="fa-brands fa-x-twitter"></i></a></li>
                                <li><a href="#" target="_blank"><i class="fa-brands fa-linkedin-in"></i></a></li>
                                <li><a href="#" target="_blank"><i class="fa-brands fa-instagram"></i></a></li>
                            </ul>
                        </div>
                    </div>
                    <a href="#" class="q-enquiry" data-bs-toggle="modal" data-bs-target="#enquiryModal">Quick Enquiry <i class="fa-solid fa-message"></i></a>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- =====related packages starts===== -->
<section class="related-trip sp-b">
    <div class="maincontainer">
        <div class="section-heading text-center mb">
            <span>You May also Like</span>
            <h2>Related Trips</h2>
            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/divider.png" alt="divider" title="divider">
        </div>
        <div class="swiper packageSlider1">
            <div class="swiper-wrapper">
                <div class="swiper-slide">
                    <a href="<?php echo home_url(); ?>">
                        <div class="card3">
                            <div class="image">
                                <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/mi4.jpg" alt="image">
                            </div>
                            <div class="text">
                                <div class="destination">
                                    <i class="fa-solid fa-location-dot"></i> <span>Everest Region</span>
                                </div>
                                <h3>Everest Basecamp Trek</h3>
                                <div class="info d-flex">
                                    <div class="duration">
                                        <i class="fa-regular fa-clock"></i> <span>11 Days/10 Nights</span>
                                    </div>
                                    <div class="group">
                                        <i class="fa-regular fa-user"></i>
                                        <span>10-15 Person</span>
                                    </div>
                                </div>
                                <div class="txt-ft d-flex">
                                    <div class="price"><span>Price From </span>
                                        <h6>$1240</h6>
                                    </div>
                                    <div class="link">
                                        Explore More <i class="fa-solid fa-arrow-right"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="swiper-slide">
                    <a href="<?php echo home_url(); ?>">
                        <div class="card3">
                            <div class="image">
                                <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/mi1.jpg" alt="image">
                            </div>
                            <div class="text">
                                <div class="destination">
                                    <i class="fa-solid fa-location-dot"></i> <span>Annapurna Region</span>
                                </div>
                                <h3>Annapurna Circuit Trek</h3>
                                <div class="info d-flex">
                                    <div class="duration">
                                        <i class="fa-regular fa-clock"></i> <span>10 Days/9 Nights</span>
                                    </div>
                                    <div class="group">
                                        <i class="fa-regular fa-user"></i>
                                        <span>10-15 Person</span>
                                    </div>
                                </div>
                                <div class="txt-ft d-flex">
                                    <div class="price"><span>Price From </span>
                                        <h6>$1240</h6>
                                    </div>
                                    <div class="link">
                                        Explore More <i class="fa-solid fa-arrow-right"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="swiper-slide">
                    <a href="<?php echo home_url(); ?>">
                        <div class="card3">
                            <div class="image">
                                <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/mi3.jpg" alt="image">
                            </div>
                            <div class="text">
                                <div class="destination">
                                    <i class="fa-solid fa-location-dot"></i> <span>Everest Region</span>
                                </div>
                                <h3>Mahure Danda Trek</h3>
                                <div class="info d-flex">
                                    <div class="duration">
                                        <i class="fa-regular fa-clock"></i> <span>10 Days/9 Nights</span>
                                    </div>
                                    <div class="group">
                                        <i class="fa-regular fa-user"></i>
                                        <span>10-15 Person</span>
                                    </div>
                                </div>
                                <div class="txt-ft d-flex">
                                    <div class="price"><span>Price From </span>
                                        <h6>$1240</h6>
                                    </div>
                                    <div class="link">
                                        Explore More <i class="fa-solid fa-arrow-right"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="swiper-slide">
                    <a href="<?php echo home_url(); ?>">
                        <div class="card3">
                            <div class="image">
                                <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/mi3.jpg" alt="image">
                            </div>
                            <div class="text">
                                <div class="destination">
                                    <i class="fa-solid fa-location-dot"></i> <span>Everest Region</span>
                                </div>
                                <h3>Nur Phu Valley Trek Trek</h3>
                                <div class="info d-flex">
                                    <div class="duration">
                                        <i class="fa-regular fa-clock"></i> <span>11 Days/10 Nights</span>
                                    </div>
                                    <div class="group">
                                        <i class="fa-regular fa-user"></i>
                                        <span>10-15 Person</span>
                                    </div>
                                </div>
                                <div class="txt-ft d-flex">
                                    <div class="price"><span>Price From </span>
                                        <h6>$2240</h6>
                                    </div>
                                    <div class="link">
                                        Explore More <i class="fa-solid fa-arrow-right"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                <div class="swiper-slide">
                    <a href="<?php echo home_url(); ?>">
                        <div class="card3">
                            <div class="image">
                                <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/im2.jpg" alt="image">
                            </div>
                            <div class="text">
                                <div class="destination">
                                    <i class="fa-solid fa-location-dot"></i> <span>Everest Region</span>
                                </div>
                                <h3>Everest Basecamp Trek</h3>
                                <div class="info d-flex">
                                    <div class="duration">
                                        <i class="fa-regular fa-clock"></i> <span>11 Days/10 Nights</span>
                                    </div>
                                    <div class="group">
                                        <i class="fa-regular fa-user"></i>
                                        <span>10-15 Person</span>
                                    </div>
                                </div>
                                <div class="txt-ft d-flex">
                                    <div class="price"><span>Price From </span>
                                        <h6>$1240</h6>
                                    </div>
                                    <div class="link">
                                        Explore More <i class="fa-solid fa-arrow-right"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </div>
</section>
<!-- =====related packages ends===== -->

<!-- Modal for quick enquiry starts -->
<div class="modal fade" id="enquiryModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Quick Enquiry</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="">
                    <label>Full Name <span>*</span></label>
                    <input type="text" class="form-control" placeholder="Enter your name">
                    <label>Email <span>*</span></label>
                    <input type="email" class="form-control" placeholder="Enter your email">
                    <label>Phone <span>*</span></label>
                    <input type="text" class="form-control" placeholder="Enter your phone">
                    <label>Subject</label>
                    <input type="text" class="form-control" placeholder="Enter subject">
                    <label>Message <span>*</span></label>
                    <textarea class="form-control" placeholder="Enter message"></textarea>
                    <input type="submit" value="Submit Now">
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Modal for quick enquiry ends -->
<!-- Modal for quick enquiry starts -->
<div class="modal fade" id="bookModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Book This Trip</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="">
                    <label>Full Name <span>*</span></label>
                    <input type="text" class="form-control" placeholder="Enter your name">
                    <label>Email <span>*</span></label>
                    <input type="email" class="form-control" placeholder="Enter your email">
                    <label>Phone <span>*</span></label>
                    <input type="text" class="form-control" placeholder="Enter your phone">
                    <label>Subject</label>
                    <input type="text" class="form-control" placeholder="Enter subject">
                    <label>Message <span>*</span></label>
                    <textarea class="form-control" placeholder="Enter message"></textarea>
                    <input type="submit" value="Submit Now">
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Modal for quick enquiry ends -->
<?php get_footer(); ?>