<?php get_header(); ?>
<!-- Modal for quick enquiry starts -->
<div class="modal fade" id="enquiryModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="exampleModalLabel">Quick Enquiry</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="">
                    <label>Full Name <span>*</span></label>
                    <input type="text" class="form-control" placeholder="Enter your name">
                    <label>Email <span>*</span></label>
                    <input type="email" class="form-control" placeholder="Enter your email">
                    <label>Phone <span>*</span></label>
                    <input type="text" class="form-control" placeholder="Enter your phone">
                    <label>Subject</label>
                    <input type="text" class="form-control" placeholder="Enter subject">
                    <label>Message <span>*</span></label>
                    <textarea class="form-control" placeholder="Enter message"></textarea>
                    <input type="submit" value="Submit Now">
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Modal for quick enquiry ends -->

<div class="pkg-category sp-tb">
    <div class="maincontainer">
        <div class="row">
            <div class="col-lg-9 col-md-8">
                <div class="cate-intro">
                    <h2 class="cate-title"> <i class="fa-solid fa-map-location-dot"></i> Trekking</h2>
                    <div class="pkg-count">Showing <span>6</span> Results</div>
                    <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/mi4.jpg" alt="category image" title="category image">
                    <div class="desc mt">
                        <p>
                            Trekking in Nepal with Miteri Nepal Trekking offers an unforgettable journey through the majestic Himalayas, where every step unveils breathtaking mountain vistas, rich cultural encounters, and the serene beauty of nature. Whether you’re exploring the classic trails of the Annapurna and Everest regions or discovering the hidden gems of Manaslu and Langtang, our carefully crafted itineraries ensure a perfect balance of adventure, comfort, and authentic local experience. Guided by our experienced team, you’ll walk through charming mountain villages, ancient monasteries, and lush forests that reflect Nepal’s vibrant natural and cultural diversity.
                        </p>
                        <p>
                            At Miteri Nepal Trekking, we take pride in providing personalized trekking experiences designed for travelers of all backgrounds and fitness levels. Our focus is on responsible tourism—supporting local communities while preserving the pristine environment of the Himalayas. From solo adventurers to family groups, we handle every detail with care, ensuring safety, comfort, and genuine hospitality along the way. Join us for a transformative journey that goes beyond trekking—it’s a soulful exploration of Nepal’s heart, spirit, and breathtaking landscapes.
                        </p>
                    </div>
                </div>
            </div>
            <div class=" col-lg-3 col-md-4">
                <div class="expert cate-expert">
                    <h3>Talk To Trip Expert</h3>
                    <div class="exp-inner">
                        <div class="expert-intro d-flex">
                            <div class="image">
                                <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/u1.jpg" alt="expert image" title="expert image">
                            </div>
                            <div class="name">
                                <h4>Daniel Rivera</h4>
                                <h5>Trip Expert</h5>
                                <h6>Have Any Questions?</h6>
                            </div>
                        </div>
                        <p>
                            A seasoned travel expert with years of experience crafting personalized journeys and unforgettable adventures.
                        </p>
                        <div class="exp-contact">
                            <i class="fa-brands fa-whatsapp"></i>
                            <span>Whatsapp/Viber</span>
                            <a href="tel:">+977-1234567890</a>
                        </div>
                        <div class="exp-media">
                            <h6>Get In Touch</h6>
                            <ul>
                                <li><a href="#" target="_blank"><i class="fa-brands fa-facebook-f"></i></a></li>
                                <li><a href="#" target="_blank"><i class="fa-brands fa-x-twitter"></i></a></li>
                                <li><a href="#" target="_blank"><i class="fa-brands fa-linkedin-in"></i></a></li>
                                <li><a href="#" target="_blank"><i class="fa-brands fa-instagram"></i></a></li>
                            </ul>
                        </div>
                    </div>
                    <a href="#" class="q-enquiry" data-bs-toggle="modal" data-bs-target="#enquiryModal">Quick Enquiry <i class="fa-solid fa-message"></i></a>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-4 col-sm-6 d-flex mt">
                <div class="card1">
                    <a href="<?php echo home_url(); ?>/single-package">
                        <div class="image">
                            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/im2.jpg" alt="image">
                            <div class="price">
                                <span>USD 5250</span>
                            </div>
                        </div>
                        <div class="text">
                            <div class="duration"><i class="fa-regular fa-calendar-days"></i> <span>12 Days/11 Nights</span></div>
                            <h3 class="pkg-title">Everest Base Camp Trek</h3>
                            <div class="link"><i class="fa-solid fa-arrow-right"></i></div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6 d-flex mt">
                <div class="card1">
                    <a href="<?php echo home_url(); ?>/single-package">
                        <div class="image">
                            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/im4.jpg" alt="image">
                            <div class="price">
                                <span>USD 3250</span>
                            </div>
                        </div>
                        <div class="text">
                            <div class="duration"><i class="fa-regular fa-calendar-days"></i> <span>12 Days/11 Nights</span></div>
                            <h3 class="pkg-title">Manaslu Base Camp Trek</h3>
                            <div class="link"><i class="fa-solid fa-arrow-right"></i></div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6 d-flex mt">
                <div class="card1">
                    <a href="<?php echo home_url(); ?>/single-package">
                        <div class="image">
                            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/g.jpg" alt="image">
                            <div class="price">
                                <span>USD 4230</span>
                            </div>
                        </div>
                        <div class="text">
                            <div class="duration"><i class="fa-regular fa-calendar-days"></i> <span>12 Days/11 Nights</span></div>
                            <h3 class="pkg-title">Annapurna Base Camp Trek</h3>
                            <div class="link"><i class="fa-solid fa-arrow-right"></i></div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6 d-flex mt">
                <div class="card1">
                    <a href="<?php echo home_url(); ?>/single-package">
                        <div class="image">
                            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/slider2.jpg" alt="image">
                            <div class="price">
                                <span>USD 5250</span>
                            </div>
                        </div>
                        <div class="text">
                            <div class="duration"><i class="fa-regular fa-calendar-days"></i> <span>12 Days/11 Nights</span></div>
                            <h3 class="pkg-title">12 Days VIP Kailash Mansarovar Tour via Lhasa/Ali</h3>
                            <div class="link"><i class="fa-solid fa-arrow-right"></i></div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6 d-flex mt">
                <div class="card1">
                    <a href="<?php echo home_url(); ?>/single-package">
                        <div class="image">
                            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/kailash.jpg" alt="image">
                            <div class="price">
                                <span>USD 5250</span>
                            </div>
                        </div>
                        <div class="text">
                            <div class="duration"><i class="fa-regular fa-calendar-days"></i> <span>9 Days/8 Nights</span></div>
                            <h3 class="pkg-title">9 Days Kailash Mansarovar Heli Tour Ex. Lucknow</h3>
                            <div class="link"><i class="fa-solid fa-arrow-right"></i></div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6 d-flex mt">
                <div class="card1">
                    <a href="<?php echo home_url(); ?>/single-package">
                        <div class="image">
                            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/im2.jpg" alt="image">
                            <div class="price">
                                <span>USD 5250</span>
                            </div>
                        </div>
                        <div class="text">
                            <div class="duration"><i class="fa-regular fa-calendar-days"></i> <span>12 Days/11 Nights</span></div>
                            <h3 class="pkg-title">Nur Phu Valley Trek</h3>
                            <div class="link"><i class="fa-solid fa-arrow-right"></i></div>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php get_footer(); ?>