<?php
// =====custom post type for package starts=====
function my_custom_package() {
    $labels = array(
      'name'               => _x( 'Package', 'post type general name' ),
      'singular_name'      => _x( 'Package', 'post type singular name' ),
      'add_new'            => _x( 'Add New', 'Package' ),
      'add_new_item'       => __( 'Add New Package' ),
      'edit_item'          => __( 'Edit Package' ),
      'new_item'           => __( 'New Package' ),
      'all_items'          => __( 'All Package' ),
      'view_item'          => __( 'View Package' ),
      'search_items'       => __( 'Search Package' ),
      'not_found'          => __( 'No Package found' ),
      'not_found_in_trash' => __( 'No Package found in the Trash' ), 
      'parent_item_colon'  => '',
      'menu_name'          => 'Package'
  );
  
  $args = array(
      'labels'        => $labels,
      'description'   => 'Package',
      'public'        => true,
      'show_ui'        => true,
      'capability_type'  => 'post',
      'menu_position' => null,
      'supports'      => array( 'title' , 'thumbnail', 'editor', 'page-attributes'),
      'has_archive'   => true,
      'menu_icon'     => 'dashicons-category'
  );   
  register_post_type( 'package', $args );   
  }
  add_action( 'init', 'my_custom_package' );

function create_package_taxonomies() {
    $labels = array(
        'name'              => _x( 'Package Type', 'taxonomy general name', 'textdomain' ),
        'singular_name'     => _x( 'Package Type', 'taxonomy singular name', 'textdomain' ),
        'search_items'      => __( 'Search Package Type', 'textdomain' ),
        'all_items'         => __( 'All Package Type', 'textdomain' ),
        'parent_item'       => __( 'Parent Package Type', 'textdomain' ),
        'parent_item_colon' => __( 'Parent Package Type:', 'textdomain' ),
        'edit_item'         => __( 'Edit Package Type', 'textdomain' ),
        'update_item'       => __( 'Update Package Type', 'textdomain' ),
        'add_new_item'      => __( 'Add New Package Type', 'textdomain' ),
        'new_item_name'     => __( 'New Package Type Name', 'textdomain' ),
        'menu_name'         => __( 'Package Type', 'textdomain' ),
    );
    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'package-type' ),
    );
    register_taxonomy( 'package-type', array( 'package' ), $args );
}
add_action('init','create_package_taxonomies');
// =====custom post type for package ends=====

// =====custom post type for team starts=====
function my_custom_team()
{
    $labels = array(
        'name'               => _x('Team', 'post type general name'),
        'singular_name'      => _x('Team', 'post type singular name'),
        'add_new'            => _x('Add New', 'Team'),
        'add_new_item'       => __('Add New Team'),
        'edit_item'          => __('Edit Team'),
        'new_item'           => __('New Team'),
        'all_items'          => __('All Teams'),
        'view_item'          => __('View Teams'),
        'search_items'       => __('Search Teams'),
        'not_found'          => __('No Teams found'),
        'not_found_in_trash' => __('No Teams found in the Trash'),
        'parent_item_colon'  => '',
        'menu_name'          => 'Our Team'
    );
    $args = array(
        'labels'        => $labels,
        'description'   => 'team',
        'public'        => true,
        'show_ui'        => true,
        'capability_type'  => 'post',
        'supports'      => array('title', 'thumbnail', 'editor', 'page-attributes'),
        'has_archive'   => true,
        'menu_icon'     => 'dashicons-businessperson'
    );
    register_post_type('team', $args);
}
add_action('init', 'my_custom_team');
// =====custom post type for team ends=====
