<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package icebergtrek
 */
$logo = get_field('site_logo', 'option');
$social_media = get_field('social_media', 'option');
$phone_number = get_field('phone_number', 'option');
$email_address = get_field('email_address', 'option');
$location = get_field('location', 'option');
$slogan = get_field('slogan', 'option');
$trip_advisor = get_field('trip_advisor_link', 'option');
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Bree+Serif&family=Kanit:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Mulish:ital,wght@0,200..1000;1,200..1000&family=Onest:wght@100..900&display=swap" rel="stylesheet">
	
	<link rel="icon" type="image/x-icon" href="<?php echo home_url(); ?>/wp-content/uploads/2025/11/favicon.jpg">


	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?> data-bs-spy="scroll" data-bs-offset="50">
	<?php wp_body_open(); ?>
	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'icebergtrek'); ?></a>

		<header id="masthead" class="site-header">
			<div class="header-top">
				<div class="maincontainer ht-inner">
					<div class="ht-item tripadvisor">
						<a href="" target="_blank">
							<img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/tripadvisor.png" alt="tripadvisor" title="tripadvisor">
							<span>Tripadvisor</span>
						</a>
					</div>
					<div class="ht-item notification">
						<i class="fa-solid fa-bell"></i> <span>Reserve Your Spot for Kailash Mansarovar Yatra 2026 & 2027 – <a href="<?php echo home_url(); ?>/package-type/kailash-yatra/">Book Now</a></span>
					</div>
					<div class="ht-item">
						<ul class="ht-media">
							<?php
							if (!empty($social_media)) {
								foreach ($social_media as $media) {
							?>
									<li>
										<a href="<?php echo $media['link']; ?>" target="_blank"><?php echo $media['icon']; ?></a>
									</li>
							<?php }
							} ?>
						</ul>
					</div>
				</div>
			</div>
			<div class="header-mid">
				<div class="maincontainer hm-inner">
					<div class="logo">
						<h1 class="m-0">
							<a href="<?php echo home_url(); ?>">
								<img src="<?php echo $logo['url']; ?>" alt="miteri nepal trekking" title="miteri nepal trekking">
							</a>
						</h1>
					</div>
					<div class="hm-contact">
						<div class="hm-item">
							<a href="<?php echo home_url(); ?>/contact ">
								<img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/trekking.png" alt="">
								<span>Plan Your Trip</br>With Trek Expert</span>
							</a>
						</div>
						<div class="hm-item qcontact">
							<i class="fa-solid fa-phone-volume"></i>
							<span>Quick Contact</span>
							<?php
							$i = 1;
							foreach ($phone_number as $phone) {
								if ($i > 1) {
									break;
								}
								$i++;
							?>
								<a href="tel:<?php echo $phone['phone']; ?>"><?php echo $phone['phone']; ?></a>
							<?php } ?>
						</div>
						<div class="hm-item search-desktop p-0">
							<form action="">
								<div class="input-group">
									<input type="text" class="form-control" placeholder="search your trip">
									<i class="fa-solid fa-magnifying-glass"></i>
								</div>
							</form>
						</div>
					</div>
				</div>
			</div>
			<div class="header-btm">
				<div class="maincontainer">
					<div class="menu-wrap">
						<div class="search-mob">
							<form action="">
								<div class="input-group">
									<input type="text" class="form-control" placeholder="search your trip">
									<button type="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
								</div>
							</form>
						</div>
						<?php wp_nav_menu(array('theme_location' => 'menu-1', 'menu_id' => 'primary-menu',)); ?>
					</div>
				</div>
			</div>

		</header><!-- #masthead -->