<?php

/**
 * icebergtrek functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package icebergtrek
 */

if (! defined('_S_VERSION')) {
	// Replace the version number of the theme on each release.
	define('_S_VERSION', '1.0.0');
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function icebergtrek_setup()
{
	/*
		* Make theme available for translation.
		* Translations can be filed in the /languages/ directory.
		* If you're building a theme based on icebergtrek, use a find and replace
		* to change 'icebergtrek' to the name of your theme in all the template files.
		*/
	load_theme_textdomain('icebergtrek', get_template_directory() . '/languages');

	// Add default posts and comments RSS feed links to head.
	add_theme_support('automatic-feed-links');

	/*
		* Let WordPress manage the document title.
		* By adding theme support, we declare that this theme does not use a
		* hard-coded <title> tag in the document head, and expect WordPress to
		* provide it for us.
		*/
	add_theme_support('title-tag');

	/*
		* Enable support for Post Thumbnails on posts and pages.
		*
		* @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		*/
	add_theme_support('post-thumbnails');

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus(
		array(
			'menu-1' => esc_html__('Primary', 'icebergtrek'),
			'quick-links' => esc_html__('quick-links', 'icebergtrek'),
			'company-info' => esc_html__('company-info', 'icebergtrek'),
		)
	);

	/*
		* Switch default core markup for search form, comment form, and comments
		* to output valid HTML5.
		*/
	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	// Set up the WordPress core custom background feature.
	add_theme_support(
		'custom-background',
		apply_filters(
			'icebergtrek_custom_background_args',
			array(
				'default-color' => 'ffffff',
				'default-image' => '',
			)
		)
	);

	// Add theme support for selective refresh for widgets.
	add_theme_support('customize-selective-refresh-widgets');

	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);
}
add_action('after_setup_theme', 'icebergtrek_setup');

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function icebergtrek_content_width()
{
	$GLOBALS['content_width'] = apply_filters('icebergtrek_content_width', 640);
}
add_action('after_setup_theme', 'icebergtrek_content_width', 0);

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function icebergtrek_widgets_init()
{
	register_sidebar(
		array(
			'name'          => esc_html__('Sidebar', 'icebergtrek'),
			'id'            => 'sidebar-1',
			'description'   => esc_html__('Add widgets here.', 'icebergtrek'),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action('widgets_init', 'icebergtrek_widgets_init');

/**
 * Enqueue scripts and styles.
 */
function icebergtrek_scripts()
{
	wp_enqueue_style('icebergtrek-style', get_stylesheet_uri(), array(), _S_VERSION);
	wp_style_add_data('icebergtrek-style', 'rtl', 'replace');

	// =====css starts =====
	// bootstrap css
	wp_enqueue_style('icebergtrek-bootstrap-css', get_template_directory_uri() . '/resources/scss/vendor/bootstrap.min.css');
	// lightbox css
	wp_enqueue_style('icebergtrek-lightbox-css', get_template_directory_uri() . '/resources/lightbox/css/lightbox.min.css');
	// swiper css
	wp_enqueue_style('icebergtrek-swiper-css', get_template_directory_uri() . '/resources/scss/vendor/swiper-bundle.min.css');
	// fontawesome css
	wp_enqueue_style('icebergtrek-fontawesome-css', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css');
	// light gallery css
	wp_enqueue_style('icebergtrek-lightgallery-css', 'https://cdnjs.cloudflare.com/ajax/libs/lightgallery/1.6.12/css/lightgallery.min.css');
	// custom css
	wp_enqueue_style('icebergtrek-main-css', get_template_directory_uri() . '/resources/scss/main.css');
	// ======css ends====== 
	// ======js starts ======
	//popper js
	wp_enqueue_script('icebergtrek-popper', 'https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js', array(), _S_VERSION, true);
	// jquery js
	wp_enqueue_script('icebergtrek-jquery-js', get_template_directory_uri() . '/resources/js/vendor/jquery.min.js', array(), _S_VERSION, true);
	// bootstrap js
	wp_enqueue_script('icebergtrek-bundle', get_template_directory_uri() . '/resources/js/vendor/bootstrap.min.js', array(), _S_VERSION, true);
	// swiper js
	wp_enqueue_script('icebergtrek-swiper-js', get_template_directory_uri() . '/resources/js/vendor/swiper-bundle.min.js', array(), _S_VERSION, true);
	// lightbox
	wp_enqueue_script('icebergtrek-lightbox-js', get_template_directory_uri() . '/resources/lightbox/js/lightbox.min.js', array(), _S_VERSION, true);
	// light gallery
	wp_enqueue_script('icebergtrek-lightgallery-js', 'https://cdnjs.cloudflare.com/ajax/libs/lightgallery/1.6.12/js/lightgallery-all.min.js', array(), _S_VERSION, true);
	// main js
	wp_enqueue_script('icebergtrek-main-js', get_template_directory_uri() . '/resources/js/custom/main.js', array(), _S_VERSION, true);
	// ======js ends======

	wp_enqueue_script('icebergtrek-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true);

	if (is_singular() && comments_open() && get_option('thread_comments')) {
		wp_enqueue_script('comment-reply');
	}
}
add_action('wp_enqueue_scripts', 'icebergtrek_scripts');

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if (defined('JETPACK__VERSION')) {
	require get_template_directory() . '/inc/jetpack.php';
}

//custom post type
require get_template_directory() . '/inc/custom-posttype.php';

if (function_exists('acf_add_options_page')) {

	acf_add_options_page(array(
		'page_title'    => 'Theme Settings',
		'menu_title'    => 'Theme Settings',
		'menu_slug'     => 'theme-settings',
		'capability'    => 'edit_posts',
		'redirect'      => false
	));
}

function example_cats_related_post()
{

	global $post; // IMPORTANT FIX

	if (! $post) return; // Safety check

	$terms = get_the_terms($post->ID, 'package-type');

	if (empty($terms)) $terms = array();

	$term_list = wp_list_pluck($terms, 'slug');

	$related_args = array(
		'post_type' => 'package',
		'post_status' => 'publish',
		'post__not_in' => array($post->ID),
		'orderby' => 'rand',
		'tax_query' => array(
			array(
				'taxonomy' => 'package-type',
				'field' => 'slug',
				'terms' => $term_list
			)
		)
	);

	$my_query = new WP_Query($related_args);

	if ($my_query->have_posts()) {
		while ($my_query->have_posts()) : $my_query->the_post();
			$price = get_field('price');
			$duration = get_field('duration');
			$destination = get_field('destination');
			$group = get_field('group_size');
?>
			<div class="swiper-slide">
				<a href="<?php the_permalink(); ?>">
					<div class="card3">
						<div class="image">
							<img src="<?php the_post_thumbnail_url(); ?>" alt="package image" title="package image">
						</div>
						<div class="text">
							<div class="destination">
								<i class="fa-solid fa-location-dot"></i>
								<span><?php echo !empty($destination) ? $destination : 'Destination N/A'; ?></span>
							</div>
							<h3><?php the_title(); ?></h3>
							<div class="info d-flex">
								<div class="duration">
									<i class="fa-regular fa-clock"></i>
									<span><?php echo !empty($duration) ? $duration : 'Duration N/A'; ?></span>
								</div>
								<div class="group">
									<i class="fa-regular fa-user"></i>
									<span><?php echo !empty($group) ? $group : 'Group N/A'; ?></span>
								</div>
							</div>
							<div class="txt-ft d-flex">
								<div class="price">
									<span>Price From </span>
									<h6><?php echo !empty($price) ? $price : 'On Request'; ?></h6>
								</div>
								<div class="link">
									Explore More <i class="fa-solid fa-arrow-right"></i>
								</div>
							</div>
						</div>
					</div>
				</a>
			</div>
<?php endwhile;

		wp_reset_postdata();
	}
}
