<?php get_header(); ?>
<!-- =====section hero slider starts===== -->
<section class="swiper heroSlider">
    <div class="swiper-wrapper">
        <?php
        $hero_video = get_field('hero_video');
        if (!empty($hero_video)) {
            foreach ($hero_video as $video) {
        ?>
                <div class="swiper-slide">
                    <div class="image">
                        <img src="<?php echo $video['background_image']['url']; ?>" alt="slide image" title="slide image">
                        <div class="text">
                            <h2><?php echo $video['subheading']; ?></h2>
                            <h3><?php echo $video['subheading']; ?></h3>
                            <div class="video-gallery">
                                <a href="<?php echo $video['video_link']; ?>">
                                    <div class="icon"><i class="fa-solid fa-play"></i></div>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
        <?php }
        } ?>
    </div>
    <div class="swiper-pagination"></div>
    <div class="btm-border">
        <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/border.png" alt="border" title="border">
    </div>
</section>
<!-- =====section hero slider ends===== -->

<!-- =====section trip type starts===== -->
<section class="trip-type sp-tb">
    <div class="maincontainer">
        <div class="swiper triptypeSlider">
            <div class="swiper-wrapper">
                <?php
                $taxonomy = 'package-type';
                $args = array(
                    'hide_empty' => false, // get all terms
                );
                $terms = get_terms($taxonomy, $args);

                if (!empty($terms) && !is_wp_error($terms)) {
                    foreach ($terms as $term) {
                        // Only show if term has packages
                        if ($term->count > 0) {
                            $image = get_field('icon_image', $term);
                            $term_link = get_term_link($term); // <-- generate the term link
                            if (is_wp_error($term_link)) continue;
                ?>
                            <div class="swiper-slide">
                                <a href="<?php echo esc_url($term_link); ?>">
                                    <div class="image">
                                        <?php if (!empty($image)) { ?>
                                            <img src="<?php echo esc_url($image['url']); ?>" alt="package type image" title="package type image">
                                        <?php } else { ?>
                                            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/hiking.png" alt="package type image" title="package type image">
                                        <?php } ?>
                                    </div>
                                    <div class="text">
                                        <h4><?php echo esc_html($term->name); ?></h4>
                                        <h5><?php echo esc_html($term->count); ?> Packages</h5>
                                    </div>
                                </a>
                            </div>
                <?php
                        }
                    }
                }
                ?>
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </div>
</section>
<!-- =====section trip type ends===== -->

<!-- =====section welcome starts===== -->
<?php $welcome = get_field('welcome'); ?>
<div class="decor-top">
    <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/h1-img-26.jpg" alt="art" title="art">
</div>
<section class="welcome">
    <div class="maincontainer">
        <div class="section-heading text-center mb">
            <span><?php echo $welcome['subheading']; ?></span>
            <h2><?php echo $welcome['heading']; ?></h2>
            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/divider.png" alt="divider" title="divider">
        </div>
        <div class="welcome-desc text-center">
            <?php echo $welcome['description']; ?>
            <a href="<?php echo home_url(); ?>/about-us" class="btn-one active">Read More</a>
        </div>
    </div>
</section>
<!-- =====section welcome ends===== -->

<!-- =====section package display 1 starts===== -->
<?php $display1 = get_field('package_display1'); ?>
<section class="display1 sp-b">
    <div class="maincontainer">
        <div class="section-heading text-center">
            <span>
                <?php if (!empty($display1['subheading'])) {
                    echo $display1['subheading'];
                } ?>
            </span>
            <h2>
                <?php if (!empty($display1['heading'])) {
                    echo $display1['heading'];
                } ?>
            </h2>
            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/divider.png" alt="divider" title="divider">
        </div>
        <div class="row">
            <?php
            if (!empty($display1['packages'])) {
                foreach ($display1['packages'] as $package) {
                    $post_id = $package->ID;
                    $price = get_field('price', $post_id);
                    $duration = get_field('duration', $post_id);
                    $destination = get_field('destination', $post_id);
                    $group = get_field('group_size', $post_id);
                    $img = get_the_post_thumbnail_url($post_id);
                    $permalink = get_the_permalink($post_id);
                    $title = get_the_title($post_id);
            ?>
                    <div class="col-lg-4 col-sm-6 d-flex mt">
                        <div class="card1">
                            <a href="<?php echo $permalink; ?>">
                                <div class="image">
                                    <img src="<?php echo $img; ?>" alt="package image" title="package image">
                                    <div class="price">
                                        <span><?php if (!empty($price)) {
                                                    echo $price;
                                                } else {
                                                    echo 'Price On Request';
                                                } ?></span>
                                    </div>
                                </div>
                                <div class="text">
                                    <div class="duration"><i class="fa-regular fa-calendar-days"></i>
                                        <span>
                                            <?php if (!empty($duration)) {
                                                echo $duration;
                                            } else {
                                                echo 'Duration N/A';
                                            }  ?>
                                        </span>
                                    </div>
                                    <h3 class="pkg-title"><?php echo $title; ?></h3>
                                    <div class="link"><i class="fa-solid fa-arrow-right"></i></div>
                                </div>
                            </a>
                        </div>
                    </div>
            <?php }
            }
            wp_reset_query(); ?>
        </div>
    </div>
</section>
<!-- =====section package display 1 ends===== -->

<!-- =====section features starts===== -->
<?php $fh = get_field('feature_headings'); ?>
<section class="feature sp-tb">
    <div class="maincontainer">
        <div class="section-heading text-center">
            <span>
                <?php if (!empty($fh['subheading'])) {
                    echo $fh['subheading'];
                } ?>
            </span>
            <h2>
                <?php if (!empty($fh['heading'])) {
                    echo $fh['heading'];
                } ?>
            </h2>
            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/divider.png" alt="divider" title="divider">
        </div>
        <div class="row">
            <?php
            $features = get_field('features');
            if (!empty($features)) {
                foreach ($features as $ft) {
            ?>
                    <div class="col-lg-4 col-sm-6 mt">
                        <div class="card-ft">
                            <div class="icon">
                                <?php echo $ft['icon']; ?>
                            </div>
                            <div class="text">
                                <h3><?php echo $ft['title']; ?></h3>
                                <p><?php echo $ft['short_description']; ?></p>
                            </div>
                        </div>
                    </div>
            <?php }
            }
            wp_reset_query(); ?>
        </div>
    </div>
</section>
<!-- =====section features ends===== -->

<!-- =====section display 2 starts===== -->
<?php $display2 = get_field('package_display2'); ?>
<section class="display2 sp-tb" style="background-image: url(<?php echo home_url(); ?>/wp-content/uploads/2025/11/im4.jpg);">
    <div class="maincontainer">
        <div class="section-heading text-center mb">
            <span>
                <?php if (!empty($display2['subheading'])) {
                    echo $display2['subheading'];
                } ?>
            </span>
            <h2>
                <?php if (!empty($display2['heading'])) {
                    echo $display2['heading'];
                } ?>
            </h2>
            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/divider.png" alt="divider" title="divider">
        </div>
        <div class="swiper packageSlider1">
            <div class="swiper-wrapper">
                <?php
                if (!empty($display1['packages'])) {
                    foreach ($display1['packages'] as $package) {
                        $post_id = $package->ID;
                        $price = get_field('price', $post_id);
                        $duration = get_field('duration', $post_id);
                        $destination = get_field('destination', $post_id);
                        $group = get_field('group_size', $post_id);
                        $img = get_the_post_thumbnail_url($post_id);
                        $permalink = get_the_permalink($post_id);
                        $title = get_the_title($post_id);
                ?>
                        <div class="swiper-slide">
                            <a href="<?php echo $permalink; ?>">
                                <div class="card3">
                                    <div class="image">
                                        <img src="<?php echo $img; ?>" alt="image">
                                    </div>
                                    <div class="text">
                                        <div class="destination">
                                            <i class="fa-solid fa-location-dot"></i>
                                            <span>
                                                <?php if (!empty($destination)) {
                                                    echo $destination;
                                                } else {
                                                    echo 'Destination N/A';
                                                }  ?>
                                            </span>
                                        </div>
                                        <h3><?php echo $title; ?></h3>
                                        <div class="info d-flex">
                                            <div class="duration">
                                                <i class="fa-regular fa-clock"></i>
                                                <span>
                                                    <?php if (!empty($duration)) {
                                                        echo $duration;
                                                    } else {
                                                        echo 'Duration N/A';
                                                    }  ?>
                                                </span>
                                            </div>
                                            <div class="group">
                                                <i class="fa-regular fa-user"></i>
                                                <span>
                                                    <?php if (!empty($group)) {
                                                        echo $group;
                                                    } else {
                                                        echo 'Group Size N/A';
                                                    } ?>
                                                </span>
                                            </div>
                                        </div>
                                        <div class="txt-ft d-flex">
                                            <div class="price"><span>Price From </span>
                                                <h6>
                                                    <?php if (!empty($price)) {
                                                        echo $price;
                                                    } else {
                                                        echo 'On Request';
                                                    } ?>
                                                </h6>
                                            </div>
                                            <div class="link">
                                                Explore More <i class="fa-solid fa-arrow-right"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                <?php }
                }
                wp_reset_query(); ?>
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </div>
</section>
<!-- =====section display 2 ends===== -->

<!-- =====section fixed departure starts===== -->
<section class="fixed-departure sp-tb">
    <div class="maincontainer">
        <div class="section-heading text-center mb">
            <span>Where Heaven meets Earth</span>
            <h2>Join Our Fixed Departures</h2>
            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/divider.png" alt="divider" title="divider">
        </div>
        <div class="swiper departure-slider">
            <div class="swiper-wrapper">
                <?php
                $package = array('post_type' => 'package', 'order' => 'DESC');
                $packagequery = new WP_Query($package);
                if ($packagequery->have_posts()) {
                    while ($packagequery->have_posts()) {
                        $packagequery->the_post();
                        $fixed_departure = get_field('fixed_departure');
                        $duration = get_field('duration');
                        $price = get_field('price');
                        $group = get_field('group_size');
                        if (!empty($fixed_departure)) {
                ?>
                            <div class="swiper-slide">
                                <div class="image">
                                    <img src="<?php the_post_thumbnail_url(); ?>" alt="image">
                                </div>
                                <div class="text">
                                    <h4>
                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                    </h4>
                                    <div class="duration">
                                        <i class="fa-solid fa-calendar-days"></i>
                                        <h6>Duration: </h6>
                                        <span>
                                            <?php if (!empty($duration)) {
                                                echo $duration;
                                            } else {
                                                echo 'N/A';
                                            } ?>
                                        </span>
                                    </div>
                                    <h5 class="price"><span>Price From </span>
                                        <?php if (!empty($price)) {
                                            echo $price;
                                        } else {
                                            echo 'N/A';
                                        } ?>
                                    </h5>
                                    <div class="star">
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                    </div>
                                    <div class="det-btn"><a href="<?php the_permalink(); ?>" class="btn-one">View Detail</a></div>
                                    <p>Upcoming Departures: </p>
                                    <ul>
                                        <?php foreach ($fixed_departure as $fd) { ?>
                                            <li>
                                                <h6><?php echo date("d M Y", strtotime($fd['start_date'])); ?></h6>
                                                <span><?php echo $fd['space_left']; ?> Seats Left</span>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </div>
                            </div>
                <?php }
                    }
                }
                wp_reset_query(); ?>
            </div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        </div>
    </div>
</section>
<!-- =====section fixed departure ends===== -->

<!-- =====section display 3 starts===== -->
<?php $display3 = get_field('package_display3'); ?>
<section class="display3 sp-b">
    <div class="maincontainer">
        <div class="section-heading text-center">
            <span>
                <?php if (!empty($display3['subheading'])) {
                    echo $display3['subheading'];
                } ?>
            </span>
            <h2>
                <?php if (!empty($display3['heading'])) {
                    echo $display3['heading'];
                } ?>
            </h2>
            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/divider.png" alt="divider" title="divider">
        </div>
        <div class="row">
            <?php
            if (!empty($display1['packages'])) {
                foreach ($display1['packages'] as $package) {
                    $post_id = $package->ID;
                    $price = get_field('price', $post_id);
                    $duration = get_field('duration', $post_id);
                    $destination = get_field('destination', $post_id);
                    $group = get_field('group_size', $post_id);
                    $img = get_the_post_thumbnail_url($post_id);
                    $permalink = get_the_permalink($post_id);
                    $title = get_the_title($post_id);
            ?>
                    <div class="col-md-6 mt">
                        <div class="card2">
                            <a href="<?php echo $title; ?>">
                                <img src="<?php echo $img; ?>" alt="package image" title="package image">
                                <div class="text-wrap">
                                    <div class="text">
                                        <div class="duration"><i class="fa-regular fa-calendar-days"></i>
                                            <span>
                                                <?php if (!empty($duration)) {
                                                    echo $duration;
                                                } else {
                                                    echo 'Duration N/A';
                                                }  ?>
                                            </span>
                                        </div>
                                        <h3><?php echo $title; ?></h3>
                                    </div>
                                    <div class="link"><i class="fa-solid fa-arrow-right"></i></div>
                                </div>
                                <div class="price">
                                    <span>
                                        <?php if (!empty($price)) {
                                            echo $price;
                                        } else {
                                            echo 'Price On Request';
                                        }  ?>
                                    </span>
                                </div>
                            </a>
                        </div>
                    </div>
            <?php }
            }
            wp_reset_query(); ?>
        </div>
    </div>
</section>
<!-- =====section display 3 ends===== -->

<!-- ======section testimonial starts===== -->
<?php $th = get_field('testimonial_headings'); ?>
<section class="testimonial sp-b">
    <div class="maincontainer">
        <div class="section-heading text-center mb">
            <span> <?php if (!empty($th['subheading'])) {
                        echo $th['subheading'];
                    } ?> </span>
            <h2><?php if (!empty($th['heading'])) {
                    echo $th['heading'];
                } ?></h2>
            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/divider.png" alt="divider" title="divider">
        </div>
        <div class="swiper testimonialSlider">
            <div class="swiper-wrapper">
                <?php
                $testimonial = get_field('testimonial');
                if (!empty($testimonial)) {
                    foreach ($testimonial as $test) {
                ?>
                        <div class="swiper-slide test-card">
                            <div class="rating">
                                <i class="fa-solid fa-star"></i>
                                <i class="fa-solid fa-star"></i>
                                <i class="fa-solid fa-star"></i>
                                <i class="fa-solid fa-star"></i>
                                <i class="fa-solid fa-star"></i>
                            </div>
                            <div class="author d-flex">
                                <div class="image">
                                    <img src="<?php echo $test['image']['url']; ?>" alt="author image" title="author image">
                                </div>
                                <div class="name">
                                    <h3><?php echo $test['name']; ?></h3>
                                    <a href="#"><?php echo $test['customer_info']; ?></a>
                                </div>
                            </div>
                            <div class="desc">
                                <p> <?php echo $test['review']; ?> </p>
                            </div>
                        </div>
                <?php }
                }
                wp_reset_query(); ?>
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </div>
</section>
<!-- ======section testimonial ends===== -->
 
<?php get_footer(); ?>