<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package icebergtrek
 */
$logo = get_field('site_logo', 'option');
$social_media = get_field('social_media', 'option');
$phone_number = get_field('phone_number', 'option');
$landline_number = get_field('landline_number', 'option');
$email_address = get_field('email_address', 'option');
$location = get_field('location', 'option');
$facebook = get_field('facebook', 'option');
$association = get_field('association', 'option');
$tripadvisor_link = get_field('tripadvisor_link', 'option');
$tripadvisor_write_review = get_field('tripadvisor_write_review', 'option');
$google_link = get_field('google_link', 'option');
$google_write_review = get_field('google_write_review', 'option');
?>
<!-- =====section partners starts===== -->
<section class="partners">
	<div class="maincontainer">
		<div class="row">
			<div class="col-lg-6 col-sm-7">
				<div class="association">
					<h2>Associated With: </h2>
					<ul>
						<?php
						if (!empty($association)) {
							foreach ($association as $asso) {
						?>
								<li>
									<a href="<?php echo $asso['link']; ?>" target="_blank">
										<img src="<?php echo $asso['image']['url']; ?>" alt="association" title="accociation">
									</a>
								</li>
						<?php }
						} ?>
					</ul>
				</div>
			</div>
			<div class="col-lg-6 col-sm-5">
				<div class="review">
					<h2>Review Us: </h2>
					<ul>
						<li>
							<a href="<?php echo $tripadvisor_link; ?>" target="_blank" class="view-review">
								<img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/tripadvisor.png" alt="partner image" title="partner image">
								<span>Tripadvisor</span>
							</a>
							<a href="<?php echo $tripadvisor_write_review; ?>" target="_blank" class="w-review">
								Write Review
							</a>
						</li>
						<li>
							<a href="<?php echo $google_link; ?>" target="_blank" class="view-review">
								<img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/google.png" alt="partner image" title="partner image">
								<span>Google</span>
							</a>
							<a href="<?php echo $google_write_review; ?>" target="_blank" class="w-review">
								Write Review
							</a>
						</li>
					</ul>
				</div>
			</div>
		</div>
	</div>
</section>
<!-- =====section partners ends===== -->
<div class="footer-bg">
	<img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/miteri-footer.png" alt="footer bg" title="footer bg">
</div>
<footer id="colophon" class="site-footer">
	<div class="maincontainer">
		<div class="row">
			<div class="col-lg-3 col-6 mb">
				<h3 class="ft-title">Company</h3>
				<ul>
					<li>
						<a href="<?php echo home_url(); ?>/about-us">About Us</a>
					</li>
					<li>
						<a href="<?php echo home_url(); ?>/contact">Contact Us</a>
					</li>
					<li>
						<a href="<?php echo home_url(); ?>/travel-blog">Travel Blog</a>
					</li>
					<li>
						<a href="<?php echo home_url(); ?>/our-team">Our Team</a>
					</li>
				</ul>

			</div>
			<div class="col-lg-2 col-6 mb">
				<h3 class="ft-title">Destinations</h3>
				<ul>
					<li>
						<a href="<?php echo home_url(); ?>/package-type/nepal">Nepal</a>
					</li>
					<li>
						<a href="<?php echo home_url(); ?>/package-type/bhutan">Bhutan</a>
					</li>
					<li>
						<a href="<?php echo home_url(); ?>/package-type/tibet">Tibet</a>
					</li>
					<li>
						<a href="<?php echo home_url(); ?>/package-type/india">India</a>
					</li>
				</ul>
			</div>
			<div class="col-lg-3 col-sm-6 mb">
				<h3 class="ft-title">Quick Links</h3>
				<ul>
					<li>
						<a href="<?php echo home_url(); ?>/about-us">Legal Documents</a>
					</li>
					<li>
						<a href="<?php echo home_url(); ?>/">Visa Information</a>
					</li>
					<li>
						<a href="<?php echo home_url(); ?>/">Privacy Policy</a>
					</li>
					<li>
						<a href="<?php echo home_url(); ?>/">Terms & Conditions</a>
					</li>
					<li>
						<a href="<?php echo home_url(); ?>/">Booking & Refund</a>
					</li>
				</ul>
			</div>
			<div class="col-lg-4 col-sm-6 mb">
				<h3 class="ft-title">Contact Us</h3>
				<div class="contact-det">
					<ul>
						<?php if (!empty($phone_number)) { ?>
							<li>
								<i class="fa-solid fa-phone-volume"></i>
								<?php foreach ($phone_number as $phone) { ?>
									<a href="tel:<?php echo $phone['phone']; ?>"><?php echo $phone['phone']; ?></a>
								<?php } ?>
							</li>
						<?php } ?>
						<?php if (!empty($landline_number)) { ?>
							<li>
								<i class="fa-solid fa-tty"></i>
								<?php foreach ($landline_number as $landline) { ?>
									<a href="tel:<?php echo $landline['landline']; ?>"><?php echo $landline['landline']; ?></a>
								<?php } ?>
							</li>
						<?php } ?>
						<?php if (!empty($email_address)) { ?>
							<li>
								<i class="fa-solid fa-envelope-open-text"></i>
								<?php foreach ($email_address as $email) { ?>
									<a href="mailto:<?php echo $email['email']; ?>"><?php echo $email['email']; ?></a>
								<?php } ?>
							</li>
						<?php } ?>
						<?php if (!empty($location)) { ?>
							<li>
								<i class="fa-solid fa-location-dot"></i>
								<a href="#"><?php echo $location; ?></a>
							</li>
						<?php } ?>
					</ul>
				</div>
			</div>
		</div>
		<div class="copyright">
			<p>Copyright © <?php echo date('Y'); ?> Miteri Nepal Trekking. All rights reserved. Design & Developed by <a href="" target="_blank">Iceberg Technology</a></p>
		</div>
	</div>
	<a href="#" id="scroll-top"><i class="fa-solid fa-arrow-up"></i></a>
</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>