<?php get_header(); ?>

<section class="pkg-category sp-tb">
    <div class="maincontainer">
        <div class="row">
            <?php
            $args = array('post_type' => 'package', 'order' => 'DESC', 'paged' => get_query_var('paged') ? get_query_var('paged') : 1);
            $query1 = new WP_Query($args);
            if (have_posts()) {
                while ($query1->have_posts()) {
                    $query1->the_post();
                    $destination = get_field('destination');
                    $duration = get_field('duration');
                    $price = get_field('price');
                    $group = get_field('group_size');
            ?>
                    <div class="col-md-4 col-sm-6 mb d-flex">
                        <div class="card1">
                            <a href="<?php the_permalink(); ?>">
                                <div class="image">
                                    <img src="<?php the_post_thumbnail_url(); ?>" alt="package image" title="package image">
                                    <div class="price">
                                        <span>
                                            <?php if (!empty($price)) {
                                                echo $price;
                                            } else {
                                                echo 'Price On Request';
                                            } ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="text">
                                    <div class="duration"><i class="fa-regular fa-calendar-days"></i>
                                        <span>
                                            <?php if (!empty($duration)) {
                                                echo $duration;
                                            } else {
                                                echo 'Duration N/A';
                                            }  ?>
                                        </span>
                                    </div>
                                    <h3 class="pkg-title"><?php the_title(); ?></h3>
                                    <div class="link"><i class="fa-solid fa-arrow-right"></i></div>
                                </div>
                            </a>
                        </div>
                    </div>
                <?php }  ?>
                <?php
                // pagination
                $current_index = $query1->max_num_pages;
                if ($current_index > 1) {
                ?>
                    <div class="pagination mt">
                        <div class="pagenavi">
                            <?php
                            $current_page = max(1, get_query_var('paged'));
                            echo paginate_links(array(
                                'format' => '?paged=%#%',
                                'show_all' => false,
                                'total' => $current_index,
                                'current' => $current_page,
                                'type' => 'plain',
                                'prev_next' => true,
                                'prev_text' => sprintf('<<'),
                                'next_text' => sprintf('>>'),
                            ));
                            ?>
                        </div>
                        <form>
                            <?php
                            if (!empty($_GET['cat'])) {
                            ?>
                                <input type="hidden" name="cat" value="<?php echo $_GET['cat']; ?>">
                            <?php } ?>
                            <input id="inputType" type="number" min="1" max="<?php echo $current_index ?>" name="paged" value="">
                            <button type="submit" id="submit">Go to page <i class="icon-chevron-right"></i></button>
                        </form>
                    </div>
            <?php }
            } ?>
            <?php wp_reset_postdata(); ?>
        </div>
    </div>
</section>

<?php get_footer(); ?>