<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package ecommerce
 */
$logo = get_field('site_logo', 'option');
$social_media = get_field('social_media', 'option');
$phone_number = get_field('phone_number', 'option');
$email_address = get_field('email_address', 'option');
$location = get_field('location', 'option');
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&family=Gothic+A1&family=Noto+Sans:ital,wght@0,100..900;1,100..900&family=Onest:wght@100..900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>
	<div id="page" class="site">
		<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'ecommerce'); ?></a>
		<header id="masthead" class="site-header">
			<div class="header-top">
				<div class="maincontainer ht-inner">
					<div class="ht-contact">
						<i class="fa-brands fa-whatsapp"></i><i class="fa-brands fa-viber"></i>
						<?php
						$i = 1;
						foreach ($phone_number as $phone) {
							if ($i > 1) {
								break;
							}
							$i++;
						?>
							<a href="tel:<?php echo $phone['phone']; ?>"><?php echo $phone['phone']; ?></a>
						<?php } ?>
					</div>
					<div class="sub-menu">
						<ul>
							<li><a href="<?php echo home_url(); ?>/about-us">About Us</a></li>
							<li><a href="<?php echo home_url(); ?>/blog">Blog</a></li>
							<li><a href="<?php echo home_url(); ?>/faqs">FAQS</a></li>
							<li><a href="<?php echo home_url(); ?>/contact-us">Contact</a></li>
						</ul>
					</div>
				</div>
			</div>
			<div class="header-mid">
				<div class="maincontainer hm-inner">
					<div class="logo">
						<h1>
							<a href="<?php echo home_url(); ?>">
								<img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/bhairabi-logo.png" alt="logo" title="logo">
							</a>
						</h1>
					</div>
					<div class="hm-info">
						<div class="hm-item search-desktop">
							<form action="">
								<div class="input-group">
									<input type="text" class="form-control" placeholder="Search for products...">
									<button type="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
								</div>
							</form>
						</div>
						<div class="hm-item account">
							<a href="<?php echo home_url(); ?>/my-account">
								<i class="fa-solid fa-user"></i>
								<span class="text">Account</span>
							</a>
						</div>
						<div class="hm-item cart">
							<a href="<?php echo home_url(); ?>/cart">
								<i class="fa-solid fa-cart-shopping"></i>
								<span class="text">Cart</span>
								<span class="count"><?php echo WC()->cart->get_cart_contents_count(); ?></span>
							</a>
						</div>
					</div>
				</div>
			</div>
			<div class="header-btm">
				<div class="maincontainer">
					<div class="menu-wrap">
						<div class="search-mob">
							<form action="">
								<div class="input-group">
									<input type="text" class="form-control" placeholder="Search for products...">
									<button type="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
								</div>
							</form>
						</div>
						<?php wp_nav_menu(array('theme_location' => 'menu-1', 'menu_id' => 'primary',)); ?>
					</div>
				</div>
			</div>
		</header>