<?php get_header(); ?>
<!-- =====section hero slider starts===== -->

<section class="swiper heroSlider">
    <div class="swiper-wrapper">
        <?php
        $hero_slider = get_field('hero_slider');
        if (!empty($hero_slider)) {
            foreach ($hero_slider as $hs) {
        ?>
                <div class="swiper-slide">
                    <div class="text" style="background-image: url('<?php echo $hs['background_image']['url']; ?>');">
                        <h2><?php echo $hs['highlight']; ?></h2>
                        <h3><?php echo $hs['heading']; ?></h3>
                        <h4><?php echo $hs['subheading']; ?></h4>
                        <a href="<?php echo home_url(); ?>/products" class="btn-bdr">Shop Now</a>
                    </div>
                    <div class="image">
                        <img src="<?php echo $hs['image']['url']; ?>" alt="slide image" title="slide image">
                    </div>
                </div>
        <?php }
        } ?>
    </div>
    <div class="swiper-button-next"></div>
    <div class="swiper-button-prev"></div>
</section>
<!-- =====section hero slider ends===== -->

<!-- =====section product categories starts===== -->
<section class="product-category sp-tb">
    <div class="maincontainer">
        <div class="section-heading text-center mb">
            <h2>Shop Categories</h2>
            <span>From Nature’s Wool to Timeless Creations</span>
        </div>
        <div class="swiper categorySlider">
            <div class="swiper-wrapper">
                <?php
                $terms = get_terms(array(
                    'taxonomy'   => 'product_cat',
                    'hide_empty' => false,
                    'exclude' => array(16),
                ));
                ?>
                <?php foreach ($terms as $trm) {
                    $term_link = get_term_link($trm, 'product_cat');
                    $image_id = get_term_meta($trm->term_id, 'thumbnail_id', true);
                    $image_url = wp_get_attachment_image_url($image_id, 'image'); ?>
                    <div class="swiper-slide category-card">
                        <a href="<?php echo $term_link; ?>">
                            <div class="image">
                                <img src="<?php echo $image_url; ?>" alt="category image" title="category image">
                            </div>
                            <div class="text">
                                <h3><?php echo $trm->name; ?></h3>
                            </div>
                        </a>
                    </div>
                <?php } ?>
                <!-- <div class="swiper-slide category-card">
                    <a href="<?php echo home_url(); ?>/category">
                        <div class="image">
                            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/bh6.jpg" alt="category image" title="category image">
                        </div>
                        <div class="text">
                            <h3>Decors</h3>
                        </div>
                    </a>
                </div>
                <div class="swiper-slide category-card">
                    <a href="<?php echo home_url(); ?>/category">
                        <div class="image">
                            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/bh8.jpg" alt="category image" title="category image">
                        </div>
                        <div class="text">
                            <h3>Felt Bags</h3>
                        </div>
                    </a>
                </div>
                <div class="swiper-slide category-card">
                    <a href="<?php echo home_url(); ?>/category">
                        <div class="image">
                            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/bh14.jpg" alt="category image" title="category image">
                        </div>
                        <div class="text">
                            <h3>Animal Characters</h3>
                        </div>
                    </a>
                </div>
                <div class="swiper-slide category-card">
                    <a href="<?php echo home_url(); ?>/category">
                        <div class="image">
                            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/bh111.jpg" alt="category image" title="category image">
                        </div>
                        <div class="text">
                            <h3>Wool Products</h3>
                        </div>
                    </a>
                </div>
                <div class="swiper-slide category-card">
                    <a href="<?php echo home_url(); ?>/category">
                        <div class="image">
                            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/bh3.jpg" alt="category image" title="category image">
                        </div>
                        <div class="text">
                            <h3>Rugs</h3>
                        </div>
                    </a>
                </div>
                <div class="swiper-slide category-card">
                    <a href="<?php echo home_url(); ?>/category">
                        <div class="image">
                            <img src="<?php echo home_url(); ?>/wp-content/uploads/2025/11/bh11.jpg" alt="category image" title="category image">
                        </div>
                        <div class="text">
                            <h3>Felt Shoes</h3>
                        </div>
                    </a>
                </div> -->
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </div>
</section>
<!-- =====section product categories ends===== -->

<!-- =====section info banner1 starts===== -->
<?php $info_banner1 = get_field('info_banner1'); ?>
<section class="info-banner1 banner-text sp-tb">
    <div class="maincontainer">
        <?php if (!empty($info_banner1['icon'])) { ?>
            <div class="image">
                <img src="<?php echo $info_banner1['icon']['url']; ?>" alt="info banner image" title="info banner image">
            </div>
        <?php } ?>
        <div class="text">
            <h2><?php if (!empty($info_banner1)) {
                    echo $info_banner1['heading'];
                } ?></h2>
            <p><?php if (!empty($info_banner1)) {
                    echo $info_banner1['short_description'];
                } ?>
            </p>
            <a href="<?php echo home_url(); ?>" class="btn-one">View All Catelogs</a>
            <a href="<?php echo home_url(); ?>" class="btn-one light">View Company Profile</a>
        </div>
    </div>
</section>
<!-- =====section info banner1 ends===== -->

<!-- =====section product display1 starts===== -->
<section class="display1 sp-tb">
    <div class="maincontainer">
        <div class="section-heading text-center">
            <h2>New Products</h2>
            <span>From Nature’s Wool to Timeless Creations</span>
        </div>
        <div class="product-row">
            <?php
            $display1 = get_field('product_display1');
            if (!empty($display1)) {
                foreach ($display1 as $product) {
                    $post_id = $product->ID;
                    $img = get_the_post_thumbnail_url($post_id);
                    $permalink = get_the_permalink($post_id);
                    $title = get_the_title($post_id);
                    $product = wc_get_product($post_id);
                    if ($product) {
                        $price = $product->get_price_html();
            ?>
                        <div class="product-col mt">
                            <div class="card1">
                                <a href="<?php echo $permalink; ?>">
                                    <div class="image">
                                        <img src="<?php echo $img; ?>" alt="product image" title="product image">
                                    </div>
                                    <div class="text">
                                        <h3><?php echo $title; ?></h3>
                                        <h4><?php echo $price; ?></h4>
                                    </div>
                                </a>
                            </div>
                        </div>
            <?php }
                }
            }
            wp_reset_query(); ?>
        </div>
    </div>
</section>
<!-- =====section product display1 ends===== -->

<!-- =====section product display 2 starts===== -->
<?php
$d2h = get_field('display2_headings');
$phc = get_field('product_highlight_card');
?>
<section class="display2 sp-tb">
    <div class="maincontainer">
        <div class="section-heading text-center secondary">
            <h2><?php echo $d2h['heading']; ?></h2>
            <span><?php echo $d2h['subheading']; ?></span>
        </div>
        <div class="row">
            <div class="col-lg-4 col-md-5 mt">
                <div class="display-card">
                    <img src="<?php echo $phc['image']['url']; ?>" alt="image" title="image">
                    <div class="text">
                        <h3><?php echo $phc['title']; ?></h3>
                        <h4><?php echo $phc['subtitle']; ?></h4>
                        <a href="<?php echo home_url(); ?>" class="btn-one color md">Shop Now</a>
                    </div>
                </div>
            </div>
            <div class="col-lg-8 col-md-7">
                <div class="product-row2">
                    <?php
                    $display2 = get_field('product_display2');
                    if (!empty($display2)) {
                        foreach ($display2 as $product) {
                            $post_id = $product->ID;
                            $img = get_the_post_thumbnail_url($post_id);
                            $permalink = get_the_permalink($post_id);
                            $title = get_the_title($post_id);
                            $product = wc_get_product($post_id);
                            if ($product) {
                                $price = $product->get_price_html();
                    ?>
                                <div class="product-col2 mt">
                                    <div class="card1">
                                        <a href="<?php echo $permalink; ?>">
                                            <div class="image">
                                                <img src="<?php echo $img; ?>" alt="product image" title="product image">
                                            </div>
                                            <div class="text">
                                                <h3><?php echo $title; ?></h3>
                                                <h4><?php echo $price; ?></h4>
                                            </div>
                                        </a>
                                    </div>
                                </div>
                    <?php }
                        }
                    }
                    wp_reset_query(); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- =====section product display 2 ends===== -->

<!-- ======section info banner2 starts===== -->
<?php $info_banner2 = get_field('info_banner2'); ?>
<section class="info-banner2 banner-text sp-tb">
    <div class="maincontainer">
        <?php if (!empty($info_banner2['icon'])) { ?>
            <div class="image">
                <img src="<?php echo $info_banner2['icon']['url']; ?>" alt="info banner image" title="info banner image">
            </div>
        <?php } ?>
        <div class="text">
            <h2><?php if (!empty($info_banner2)) {
                    echo $info_banner2['heading'];
                } ?></h2>
            <p><?php if (!empty($info_banner2)) {
                    echo $info_banner2['short_description'];
                } ?>
            </p>
            <a href="<?php echo home_url(); ?>" class="btn-one active">Request a Quote</a>
        </div>
    </div>
</section>
<!-- ======section info banner2 ends===== -->

<!-- =====section product display 3 starts===== -->
<?php $d3h = get_field('display3_headings'); ?>
<section class="display3 sp-t">
    <div class="maincontainer">
        <div class="section-heading text-center mb">
            <h2><?php echo $d3h['heading']; ?></h2>
            <span><?php echo $d3h['subheading']; ?></span>
        </div>
        <div class="swiper productSlider">
            <div class="swiper-wrapper">
                <?php
                $display3 = get_field('product_display3');
                if (!empty($display3)) {
                    foreach ($display3 as $product) {
                        $post_id = $product->ID;
                        $img = get_the_post_thumbnail_url($post_id);
                        $permalink = get_the_permalink($post_id);
                        $title = get_the_title($post_id);
                        $product = wc_get_product($post_id);
                        if ($product) {
                            $price = $product->get_price_html();
                ?>
                            <div class="swiper-slide">
                                <div class="card1">
                                    <a href="<?php echo $permalink; ?>">
                                        <div class="image">
                                            <img src="<?php echo $img; ?>" alt="product image" title="product image">
                                        </div>
                                        <div class="text">
                                            <h3><?php echo $title; ?></h3>
                                            <h4><?php echo $price; ?></h4>
                                        </div>
                                    </a>
                                </div>
                            </div>
                <?php }
                    }
                }
                wp_reset_query(); ?>

            </div>
            <div class="swiper-pagination"></div>
        </div>
    </div>
</section>
<!-- =====section product display3 ends===== -->

<!-- =====section testimonial starts===== -->
<?php
$th = get_field('testimonial_headings');
?>
<section class="testimonial sp-tb">
    <div class="maincontainer">
        <div class="section-heading text-center mb">
            <h2><?php echo $th['heading']; ?></h2>
            <span><?php echo $th['subheading']; ?></span>
        </div>
        <div class="swiper testimonialSlider">
            <div class="swiper-wrapper">
                <?php
                $testimonial = get_field('testimonial');
                if (!empty($testimonial)) {
                    foreach ($testimonial as $test) {
                ?>
                        <div class="swiper-slide test-card">
                            <div class="rating">
                                <i class="fa-solid fa-star"></i>
                                <i class="fa-solid fa-star"></i>
                                <i class="fa-solid fa-star"></i>
                                <i class="fa-solid fa-star"></i>
                                <i class="fa-solid fa-star"></i>
                            </div>
                            <div class="author d-flex">
                                <div class="image">
                                    <img src="<?php echo $test['image']['url']; ?>" alt="author image" title="author image">
                                </div>
                                <div class="name">
                                    <h3><?php echo $test['name']; ?></h3>
                                    <a href="#"><?php echo $test['customer_info']; ?></a>
                                </div>
                            </div>
                            <div class="desc">
                                <p> <?php echo $test['review']; ?> </p>
                            </div>
                        </div>
                <?php }
                } ?>
            </div>
            <div class="swiper-pagination"></div>
        </div>
    </div>
</section>
<!-- =====section testimonial ends===== -->
<?php get_footer(); ?>