<?php

/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package ecommerce
 */
$logo = get_field('site_logo', 'option');
$social_media = get_field('social_media', 'option');
$phone_number = get_field('phone_number', 'option');
$landline_number = get_field('landline_number', 'option');
$email_address = get_field('email_address', 'option');
$location = get_field('location', 'option');
$facebook = get_field('facebook', 'option');
$association = get_field('association', 'option');
$payment_cards = get_field('payment_cards', 'option');
?>

<footer id="colophon" class="site-footer">
	<div class="footer-top sp-t">
		<div class="maincontainer">
			<div class="row">
				<div class="col-lg-3 col-sm-6 mb">
					<h2 class="ft-title">Contact Us</h2>
					<div class="contact-det">
						<ul>
							<?php if (!empty($phone_number)) { ?>
								<li>
									<i class="fa-solid fa-phone-volume"></i>
									<?php foreach ($phone_number as $phone) { ?>
										<a href="tel:<?php echo $phone['phone']; ?>"><?php echo $phone['phone']; ?></a>
									<?php } ?>
								</li>
							<?php } ?>
							<?php if (!empty($landline_number)) { ?>
								<li>
									<i class="fa-solid fa-tty"></i>
									<?php foreach ($landline_number as $landline) { ?>
										<a href="tel:<?php echo $landline['landline']; ?>"><?php echo $landline['landline']; ?></a>
									<?php } ?>
								</li>
							<?php } ?>
							<?php if (!empty($email_address)) { ?>
								<li>
									<i class="fa-solid fa-envelope-open-text"></i>
									<?php foreach ($email_address as $email) { ?>
										<a href="mailto:<?php echo $email['email']; ?>"><?php echo $email['email']; ?></a>
									<?php } ?>
								</li>
							<?php } ?>
							<?php if (!empty($location)) { ?>
								<li>
									<i class="fa-solid fa-location-dot"></i>
									<a href="#"><?php echo $location; ?></a>
								</li>
							<?php } ?>
						</ul>
					</div>
					<div class="social-media">
						<h3>Social Media</h3>
						<ul>
							<?php
							if (!empty($social_media)) {
								foreach ($social_media as $media) {
							?>
									<li>
										<a href="<?php echo $media['link']; ?>" target="_blank"><?php echo $media['icon']; ?></a>
									</li>
							<?php }
							} ?>
						</ul>
					</div>
				</div>
				<div class="col-lg-3 col-sm-6 mb">
					<h2 class="ft-title">Company</h2>
					<?php wp_nav_menu(array('theme_location' => 'menu-3',)); ?>
				</div>
				<div class="col-lg-3 col-sm-6 mb">
					<h2 class="ft-title">Useful Links</h2>
					<?php wp_nav_menu(array('theme_location' => 'menu-2',)); ?>
				</div>
				<div class="col-lg-3 col-sm-6 mb">
					<h2 class="ft-title">Newsletter</h2>
					<div class="newsletter">
						<p>Subscribe our Newsletter and get frequent updates about products.</p>
						<form action="">
							<input type="text" class="form-control" placeholder="Full name">
							<input type="email" class="form-control" placeholder="Email address">
							<input type="submit" value="Subscribe Now">
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="footer-btm">
		<div class="maincontainer fb-inner">
			<p>© <?php echo date('Y'); ?> Bhairabi Handicraft. All rights reserved. Design & Developed by <a href="" target="_blank">Iceberg Technology</a></p>
			<div class="payment-card">
				<h3>We Accept</h3>
				<ul>
					<?php 
					if(!empty($payment_cards)){
						foreach($payment_cards as $pc){
					?>
					<li>
						<img src="<?php echo $pc['url']; ?>" alt="payment method" title="payment method">
					</li>
					<?php } } ?>
				</ul>
			</div>
		</div>
	</div>
</footer><!-- #colophon -->
</div><!-- #page -->

<?php wp_footer(); ?>

</body>

</html>